package com.kdgcsoft.power.fileconverter.impl;

import java.io.File;

import org.apache.commons.io.FileUtils;

import com.kdgcsoft.power.doc2html.ConvertOptions;
import com.kdgcsoft.power.doc2html.Doc2HtmlFactory;
import com.kdgcsoft.power.doc2html.ImageFormat;
import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.IFileConverter;

/**
 * 把除Excel以外的Office/pdf文档转换为链接多页图片的HTML文件。仅依赖内置java组件，不依赖外部程序<br>
 * @author hling
 *
 */
public class Doc2MultiplePicHtmlConverter implements IFileConverter {

//	private static Logger logger = LoggerFactory.getLogger(Doc2MultiplePicHtmlConverter.class);
	
	private ConvertOptions options = new ConvertOptions();
	
	/**
	 * 构造一个Office/pdf转HTML的转换器，且生成的HTML中直接用Base64编码内嵌图片，生成的hmtl文件较大。
	 */
	public Doc2MultiplePicHtmlConverter() {
		options.setInlineImage(true);
	}
	
	/**
	 * 构造一个Office/pdf转HTML的转换器。
	 * @param isInlineImage 是否在生成的HTML中直接用Base64编码内嵌图片。
	 */
	public Doc2MultiplePicHtmlConverter(boolean isInlineImage) {
		options.setInlineImage(isInlineImage);
	}
	
	@Override
	public File convert(final File srcFile, final File destFile, final FileConverterSettings settings) throws Exception {
		String fileName = destFile.getName().toLowerCase();
		if (fileName.endsWith(".jpg") || fileName.endsWith(".png")) {
			if (fileName.endsWith(".jpg")) {
				options.setImageFormat(ImageFormat.jpg);
			} else {
				options.setImageFormat(ImageFormat.png);
			}
			options.setInlineImage(false);
			Doc2HtmlFactory.convertToHtml(srcFile.getCanonicalPath(), destFile.getCanonicalPath(), settings.getHtmlWriter(), options);
			// 删除不需要的HTML主文件
			 destFile.delete();
			// 返回存储图片的子目录
			return settings.getHtmlWriter().resolveImageDir(destFile);
		} else {
			Doc2HtmlFactory.convertToHtml(srcFile.getCanonicalPath(), destFile.getCanonicalPath(), settings.getHtmlWriter(), options);
			// 如果是内嵌图片方式，则删除子文件夹，只保留HTML主文件
			if (options.isInlineImage()) {
				File subDir = settings.getHtmlWriter().resolveImageDir(destFile);
				if (subDir.exists() && subDir.isDirectory()) {
					FileUtils.forceDelete(subDir);
				}
			}
			// 返回html文件
			return destFile;
		}
	}
	
}
