package com.kdgcsoft.power.fileconverter.impl;

import java.io.File;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.IFileConverter;

/**
 * 一个仅仅做文件拷贝的转换器，由转换引擎内部使用，应用程序不需要使用。
 * @author hling
 *
 */
public class CopyOnlyConverter implements IFileConverter {
	
	private static final Logger logger = LoggerFactory.getLogger(CopyOnlyConverter.class);

	@Override
	public File convert(final File srcFile, final File destFile, final FileConverterSettings settings) throws Exception {
		String srcExt = FilenameUtils.getExtension(srcFile.getName());
		String destExt = FilenameUtils.getExtension(destFile.getName());
		if (srcExt.equalsIgnoreCase(destExt)) {
			FileUtils.copyFile(srcFile, destFile);
		} else {
			logger.error("本转换器只处理源文件与目标文件扩展名相同的场景");
			throw new IllegalArgumentException("本转换器只处理源文件与目标文件扩展名相同的场景");
		}
		
		return destFile;
	}

}
