package com.kdgcsoft.power.fileconverter;

/**
 * 本转换器引擎所支持的输出格式枚举
 * @author hling
 *
 */
public enum OutputType {
	
	/**
	 *输出为PDF文件
	 */
	PDF,
	/**
	 * 输出为单页的HTML。HTML中内嵌所有图片。当前除了转换Excel外，都依赖外部程序Pdf2HtmlEx
	 */
	HTML,
	/**
	 * 输出为包含若干图片链接的HTML。图片会同时生成到一个子目录中。
	 */
	LINK_HTML,
	/**
	 *输出为多个PNG图片。使用者需自行解决翻页显示
	 */
	PNG,
	/**
	 *输出为多个JPG图片。使用者需自行解决翻页显示
	 */
	JPG
}
