package com.kdgcsoft.power.fileconverter;

public interface IFileStorageHelper {
	
	/**
	 * 生成一个文件Key
	 * @return 生成的文件key
	 */
	public String generateKey();
	
	/**
	 * 根据Key计算得出存储的相对路径
	 * @param key 文件存储Key
	 * @return 根据Key计算出的存储相对路径
	 */
	public String getRelativePathByKey(final String key);
	
	/**
	 * 校验一个Key是否合法。如果不合法，抛出异常。
	 * @param key 要检验的Key
	 * @throws IllegalArgumentException 当Key不合法时抛出的异常
	 */
	public void validateKey(final String key) throws IllegalArgumentException;

}
