/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.resource.oracle;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.plugin.api.param.DBResourcePluginParam;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import com.kdgcsoft.plugin.common.resource.db.SimpleDataSource;
import com.kdgcsoft.plugin.resource.oracle.OracleResourceApiController;
import com.kdgcsoft.plugin.resource.oracle.param.OracleResourcePluginParam;
import com.kdgcsoft.plugin.resource.oracle.param.OracleServiceType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class OracleResourcePlugin
extends Plugin {
    public OracleResourcePlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class OracleIResourcePlugin
    extends AbstractDBResourcePlugin
    implements ExtensionPoint {
        public void init(PluginParam pluginParam) {
            this.param = (OracleResourcePluginParam)pluginParam;
            Object connectionStr = this.buildUrl(this.param);
            if (StrUtil.isBlank((CharSequence)connectionStr)) {
                throw new IllegalArgumentException("\u8fde\u63a5\u5b57\u7b26\u4e32\u4e3a\u7a7a!");
            }
            if (StrUtil.isNotBlank((CharSequence)this.param.getAddition())) {
                connectionStr = (String)connectionStr + (this.param.getAddition().startsWith("?") ? "" : "?") + this.param.getAddition();
            }
            this.connectionString = connectionStr;
            this.username = this.param.getUsername();
            this.password = this.param.getPassword();
            this.db = this.param.getCatalog();
        }

        public Connection openConnection() throws Exception {
            String driverClass = this.driverClass();
            Class.forName(driverClass);
            return DriverManager.getConnection(this.connectionString, this.username, this.password);
        }

        protected String driverClass() {
            return "oracle.jdbc.driver.OracleDriver";
        }

        public String buildUrl(DBResourcePluginParam param) {
            OracleResourcePluginParam pluginParam = (OracleResourcePluginParam)param;
            String buildUrl = null;
            buildUrl = OracleServiceType.SERVICE_NAME.equals((Object)pluginParam.getServiceType()) ? "jdbc:oracle:thin:@//" + param.getHost() + ":" + param.getPort() + "/" + pluginParam.getServiceName() : "jdbc:oracle:thin:@" + param.getHost() + ":" + param.getPort() + ":" + pluginParam.getServiceName();
            return buildUrl;
        }

        protected DataSource buildDataSource() throws Exception {
            return new SimpleDataSource(){

                public Connection getConnection() throws SQLException {
                    try {
                        return this.openConnection();
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                }
            };
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return OracleResourcePluginParam.class;
        }

        public String configComponent() {
            return "OracleResourceConfigForm";
        }

        public Class<?> apiClass() {
            return OracleResourceApiController.class;
        }
    }
}

