/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.resource.oracle;

import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.common.model.JsonResult;
import com.kdgcsoft.plugin.api.PluginApiController;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.common.model.PageObject;
import com.kdgcsoft.plugin.resource.oracle.OracleResourcePlugin;
import com.kdgcsoft.plugin.resource.oracle.param.OracleApiQueryModel;
import com.kdgcsoft.plugin.resource.oracle.param.OracleResourcePluginParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping(value={"/OracleResourcePlugin"})
public class OracleResourceApiController
extends PluginApiController {
    private OracleResourcePlugin.OracleIResourcePlugin getPlugin() {
        OracleResourcePlugin.OracleIResourcePlugin plugin = (OracleResourcePlugin.OracleIResourcePlugin)this.getPluginInstance();
        return plugin;
    }

    @ApiOperation(value="\u6d4b\u8bd5\u8fde\u63a5", notes="\u6d4b\u8bd5\u914d\u7f6e\u7684\u8fde\u63a5\u53c2\u6570\u662f\u5426\u80fd\u8fde\u63a5\u6210\u529f")
    @PostMapping(value={"/testConnect"})
    public JsonResult testConnect(@RequestBody OracleResourcePluginParam param) {
        OracleResourcePlugin.OracleIResourcePlugin plugin = this.getPlugin();
        plugin.init((PluginParam)param);
        return plugin.testConnect();
    }

    @ApiOperation(value="\u83b7\u5f97\u6570\u636e\u5e93\u7684\u5143\u6570\u636e\u4fe1\u606f", notes="\u83b7\u5f97\u6570\u636e\u5e93\u7684\u5143\u6570\u636e\u4fe1\u606f")
    @PostMapping(value={"/getResourceMeta"})
    public JsonResult getResourceMeta(@RequestBody OracleApiQueryModel model) {
        OracleResourcePlugin.OracleIResourcePlugin plugin = this.getPlugin();
        plugin.init((PluginParam)model.getParam());
        return JsonResult.OK().data(plugin.resourceInfo());
    }

    @ApiOperation(value="\u83b7\u5f97\u6570\u636e\u5e93\u6307\u5b9a\u8868\u6570\u636e", notes="\u83b7\u5f97\u6570\u636e\u5e93\u6307\u5b9a\u8868\u6570\u636e")
    @PostMapping(value={"/getTableData"})
    public JsonResult getTableData(@RequestBody OracleApiQueryModel model) {
        OracleResourcePlugin.OracleIResourcePlugin plugin = this.getPlugin();
        plugin.init((PluginParam)model.getParam());
        HashMap paramMap = MapUtil.of((Object)"tableName", (Object)model.getTableName());
        paramMap.put("page", String.valueOf(model.getPage()));
        paramMap.put("pageSize", String.valueOf(model.getPageSize()));
        return JsonResult.OK().data(plugin.preview(paramMap));
    }

    @ApiOperation(value="\u9884\u89c8\u8d44\u6e90\u6267\u884cSQL\u8bed\u53e5\u7684\u7ed3\u679c", notes="\u9884\u89c8\u8d44\u6e90\u6267\u884cSQL\u8bed\u53e5\u7684\u7ed3\u679c,\u4e3a\u4fdd\u8bc1\u6027\u80fd\u53ca\u5b89\u5168\u6027,\u53ea\u8fd4\u56de\u6700\u591a20\u6761\u6570\u636e")
    @PostMapping(value={"/previewSqlResult"})
    public JsonResult previewSqlResult(@RequestBody OracleApiQueryModel model) {
        OracleResourcePlugin.OracleIResourcePlugin plugin = this.getPlugin();
        plugin.init((PluginParam)model.getParam());
        PageObject pageResult = plugin.previewSqlResult(model.getExecSql());
        return JsonResult.OK().data((Object)pageResult);
    }
}

