/*
 * Decompiled with CFR 0.152.
 */
package org.aheca.cn.seal.service;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.aheca.cn.seal.dto.CertRecord;
import org.aheca.cn.seal.dto.PageBean_certRecord;
import org.aheca.cn.seal.dto.PdfDataInfo2;
import org.aheca.cn.seal.dto.PdfFileInfo2;
import org.aheca.cn.seal.dto.QueryCondition_certRecord;
import org.aheca.cn.seal.dto.Rate;
import org.aheca.cn.seal.service.MD5;
import org.aheca.cn.seal.service.PdfDataInfo;
import org.aheca.cn.seal.service.PdfFileInfo;
import org.aheca.cn.seal.service.PostUtil;
import org.aheca.cn.seal.service.RandomUtil;
import org.aheca.cn.seal.service.SignInfo;
import org.aheca.cn.seal.service.Sort;

public class Sealservers {
    private static String docSignUrl_ = "/project/api/docSign";
    private static String docManySignUrl_ = "/project/api/docManySign";
    private static String verifyDocSignDataUrl_ = "/project/api/verifyDocSignData";
    private static String queryStatisticsUrl_ = "/project/api/queryStatistics";
    private static String queryRecordUrl_ = "/project/api/queryRecord";
    private String docSignUrl;
    private String docManySignUrl;
    private String verifyDocSignDataUrl;
    private String queryStatisticsUrl;
    private String queryRecordUrl;
    private String appKey;
    private String appSecret;

    public Sealservers() {
    }

    public Sealservers(String ip, String port, String appKey, String appSecret) {
        if (ip != null && !ip.trim().equals("") && port != null && !port.trim().equals("")) {
            String url = "http://" + ip + ":" + port + "/seal";
            this.docSignUrl = String.valueOf(url) + docSignUrl_;
            this.docManySignUrl = String.valueOf(url) + docManySignUrl_;
            this.verifyDocSignDataUrl = String.valueOf(url) + verifyDocSignDataUrl_;
            this.queryStatisticsUrl = String.valueOf(url) + queryStatisticsUrl_;
            this.queryRecordUrl = String.valueOf(url) + queryRecordUrl_;
        }
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public static Sealservers getInstance(String ip, String port, String appKey, String appSecret) {
        return new Sealservers(ip, port, appKey, appSecret);
    }

    public Map<String, String> docSign(String reqPdfData, List<SignInfo> signList) {
        String docSignUrl = this.docSignUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.docSign(reqPdfData, signList, docSignUrl, appKey, appSecret);
    }

    public Map<String, String> docSign(String reqPdfData, List<SignInfo> signList, String docSignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (reqPdfData == null || signList == null || signList.isEmpty() || docSignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        Collections.sort(signList);
        ArrayList list = new ArrayList();
        for (SignInfo si : signList) {
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            if (si.getSignSequence() <= 0) {
                map.put("resultCode", "080303");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signSequence(" + si.getSignSequence() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("signSequence", String.valueOf(si.getSignSequence()));
            if (si.getReqImageData() == null || si.getReqImageData().trim().equals("")) {
                map.put("resultCode", "080310");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570reqImageData(" + si.getReqImageData() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("reqImageData", si.getReqImageData());
            HashMap<String, Object> signInfoMap = new HashMap<String, Object>();
            if (si.getKeyWord() == null || si.getKeyWord().trim().equals("")) {
                map.put("resultCode", "080311");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570keyWord(" + si.getKeyWord() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("keyWord", si.getKeyWord());
            if (si.getKwIndex() == null || si.getKwIndex() == 0) {
                map.put("resultCode", "080304");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570kwIndex(" + si.getKwIndex() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("kwIndex", String.valueOf(si.getKwIndex()));
            if (si.getOffsetTop() != null || si.getOffsetRight() != null) {
                HashMap<String, String> offsetMap = new HashMap<String, String>();
                if (si.getOffsetTop() != null) {
                    offsetMap.put("top", String.valueOf(si.getOffsetTop()));
                }
                if (si.getOffsetRight() != null) {
                    offsetMap.put("right", String.valueOf(si.getOffsetRight()));
                }
                signInfoMap.put("offset", offsetMap);
            }
            if (si.getImageWidth() != null) {
                signInfoMap.put("imageWidth", String.valueOf(si.getImageWidth()));
            }
            if (si.getImageHeight() != null) {
                signInfoMap.put("imageHeight", String.valueOf(si.getImageHeight()));
            }
            signMap.put("signInfoJson", signInfoMap);
            HashMap<String, String> userInfoMap = new HashMap<String, String>();
            if (!"11".equals(si.getSignType()) && !"12".equals(si.getSignType())) {
                map.put("resultCode", "080305");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signType(" + si.getSignType() + ")\u6709\u8bef");
                return map;
            }
            userInfoMap.put("signType", si.getSignType());
            if ("1".equals(si.getSignWay()) || "2".equals(si.getSignWay())) {
                userInfoMap.put("signWay", si.getSignWay());
                if ("1".equals(si.getSignWay())) {
                    if (si.getToken() == null || si.getToken().trim().equals("")) {
                        map.put("resultCode", "080312");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570token(" + si.getToken() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("token", si.getToken());
                    if (si.getPhoneInfo() == null || si.getPhoneInfo().trim().equals("")) {
                        map.put("resultCode", "080313");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570phoneInfo(" + si.getPhoneInfo() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("phoneInfo", si.getPhoneInfo());
                }
                if ("2".equals(si.getSignWay())) {
                    if (si.getUserName() == null || si.getUserName().trim().equals("")) {
                        map.put("resultCode", "080314");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570userName(" + si.getUserName() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("userName", si.getUserName());
                    if (si.getIdCard() == null || si.getIdCard().trim().equals("")) {
                        map.put("resultCode", "080315");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570idCard(" + si.getIdCard() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("idCard", si.getIdCard());
                }
            } else {
                map.put("resultCode", "080306");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signWay(" + si.getSignWay() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("userInfoJson", userInfoMap);
            list.add(signMap);
        }
        String signJson = JSONArray.fromObject(list).toString();
        return this.docSign(reqPdfData, signJson, docSignUrl, appKey, appSecret);
    }

    private Map<String, String> docSign(String reqPdfData, String signJson, String docSignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (reqPdfData == null || signJson == null || docSignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("reqPdfData", reqPdfData);
        paramMap.put("signJson", signJson);
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        Map<String, String> docSignMap = PostUtil.sendPost(docSignUrl, paramMap, "utf-8");
        if (docSignMap == null || docSignMap.isEmpty()) {
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        if (!docSignMap.get("resultCode").equals("200")) {
            map.put("resultCode", docSignMap.get("resultCode"));
            map.put("message", docSignMap.get("message"));
            return map;
        }
        String docBase64 = null;
        try {
            JSONObject json = JSONObject.fromObject((Object)docSignMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            JSONObject data = json.getJSONObject("data");
            docBase64 = data.getString("docBase64");
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u6210\u529f");
        map.put("docBase64", docBase64);
        return map;
    }

    public Map<String, String> docSign(File reqPdfFile, List<SignInfo> signList) {
        String docSignUrl = this.docSignUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.docSign(reqPdfFile, signList, docSignUrl, appKey, appSecret);
    }

    public Map<String, String> docSign(File reqPdfFile, List<SignInfo> signList, String docSignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (reqPdfFile == null || !reqPdfFile.exists() || signList == null || signList.isEmpty() || docSignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        Collections.sort(signList);
        ArrayList list = new ArrayList();
        for (SignInfo si : signList) {
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            if (si.getSignSequence() <= 0) {
                map.put("resultCode", "080303");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signSequence(" + si.getSignSequence() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("signSequence", String.valueOf(si.getSignSequence()));
            if (si.getReqImageData() == null || si.getReqImageData().trim().equals("")) {
                map.put("resultCode", "080310");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570reqImageData(" + si.getReqImageData() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("reqImageData", si.getReqImageData());
            HashMap<String, Object> signInfoMap = new HashMap<String, Object>();
            if (si.getKeyWord() == null || si.getKeyWord().trim().equals("")) {
                map.put("resultCode", "080311");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570keyWord(" + si.getKeyWord() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("keyWord", si.getKeyWord());
            if (si.getKwIndex() == null || si.getKwIndex() == 0) {
                map.put("resultCode", "080304");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570kwIndex(" + si.getKwIndex() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("kwIndex", String.valueOf(si.getKwIndex()));
            if (si.getOffsetTop() != null || si.getOffsetRight() != null) {
                HashMap<String, String> offsetMap = new HashMap<String, String>();
                if (si.getOffsetTop() != null) {
                    offsetMap.put("top", String.valueOf(si.getOffsetTop()));
                }
                if (si.getOffsetRight() != null) {
                    offsetMap.put("right", String.valueOf(si.getOffsetRight()));
                }
                signInfoMap.put("offset", offsetMap);
            }
            if (si.getImageWidth() != null) {
                signInfoMap.put("imageWidth", String.valueOf(si.getImageWidth()));
            }
            if (si.getImageHeight() != null) {
                signInfoMap.put("imageHeight", String.valueOf(si.getImageHeight()));
            }
            signMap.put("signInfoJson", signInfoMap);
            HashMap<String, String> userInfoMap = new HashMap<String, String>();
            if (!"11".equals(si.getSignType()) && !"12".equals(si.getSignType())) {
                map.put("resultCode", "080305");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signType(" + si.getSignType() + ")\u6709\u8bef");
                return map;
            }
            userInfoMap.put("signType", si.getSignType());
            if ("1".equals(si.getSignWay()) || "2".equals(si.getSignWay())) {
                userInfoMap.put("signWay", si.getSignWay());
                if ("1".equals(si.getSignWay())) {
                    if (si.getToken() == null || si.getToken().trim().equals("")) {
                        map.put("resultCode", "080312");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570token(" + si.getToken() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("token", si.getToken());
                    if (si.getPhoneInfo() == null || si.getPhoneInfo().trim().equals("")) {
                        map.put("resultCode", "080313");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570phoneInfo(" + si.getPhoneInfo() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("phoneInfo", si.getPhoneInfo());
                }
                if ("2".equals(si.getSignWay())) {
                    if (si.getUserName() == null || si.getUserName().trim().equals("")) {
                        map.put("resultCode", "080314");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570userName(" + si.getUserName() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("userName", si.getUserName());
                    if (si.getIdCard() == null || si.getIdCard().trim().equals("")) {
                        map.put("resultCode", "080315");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570idCard(" + si.getIdCard() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("idCard", si.getIdCard());
                }
            } else {
                map.put("resultCode", "080306");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signWay(" + si.getSignWay() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("userInfoJson", userInfoMap);
            list.add(signMap);
        }
        String signJson = JSONArray.fromObject(list).toString();
        return this.docSign(reqPdfFile, signJson, docSignUrl, appKey, appSecret);
    }

    private Map<String, String> docSign(File reqPdfFile, String signJson, String docSignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (reqPdfFile == null || signJson == null || docSignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        String fileName = "file" + System.currentTimeMillis() + RandomUtil.generateString(4);
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("reqPdfData", fileName);
        paramMap.put("signJson", signJson);
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        HashMap<String, File> files = new HashMap<String, File>();
        files.put(fileName, reqPdfFile);
        Map<String, String> docSignMap = PostUtil.sendPost(docSignUrl, paramMap, files, "utf-8");
        if (docSignMap == null || docSignMap.isEmpty()) {
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        if (!docSignMap.get("resultCode").equals("200")) {
            map.put("resultCode", docSignMap.get("resultCode"));
            map.put("message", docSignMap.get("message"));
            return map;
        }
        String docBase64 = null;
        try {
            JSONObject json = JSONObject.fromObject((Object)docSignMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            JSONObject data = json.getJSONObject("data");
            docBase64 = data.getString("docBase64");
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u6210\u529f");
        map.put("docBase64", docBase64);
        return map;
    }

    public Map<String, String> verifyDocSignData(String reqPdfData) {
        String verifyDocSignDataUrl = this.verifyDocSignDataUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.verifyDocSignData(reqPdfData, verifyDocSignDataUrl, appKey, appSecret);
    }

    public Map<String, String> verifyDocSignData(String reqPdfData, String verifyDocSignDataUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (reqPdfData == null || verifyDocSignDataUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("reqPdfData", reqPdfData);
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        Map<String, String> verifyDocSignDataUrlMap = PostUtil.sendPost(verifyDocSignDataUrl, paramMap, "utf-8");
        if (verifyDocSignDataUrlMap == null || verifyDocSignDataUrlMap.isEmpty()) {
            map.put("resultCode", "080308");
            map.put("message", "POST\u8bf7\u6c42PDF\u9a8c\u7b7e\u5f02\u5e38");
            return map;
        }
        if (!verifyDocSignDataUrlMap.get("resultCode").equals("200")) {
            map.put("resultCode", verifyDocSignDataUrlMap.get("resultCode"));
            map.put("message", verifyDocSignDataUrlMap.get("message"));
            return map;
        }
        String pdfVerify = null;
        String docBase64 = null;
        try {
            JSONObject json = JSONObject.fromObject((Object)verifyDocSignDataUrlMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            JSONObject data = json.getJSONObject("data");
            pdfVerify = data.getString("pdfVerify");
            if ("false".equals(pdfVerify)) {
                docBase64 = data.getString("docBase64");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080308");
            map.put("message", "POST\u8bf7\u6c42PDF\u9a8c\u7b7e\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42PDF\u6587\u4ef6\u6709\u6548\u6027\u9a8c\u8bc1\u6210\u529f");
        map.put("pdfVerify", pdfVerify);
        map.put("docBase64", docBase64);
        return map;
    }

    public Map<String, String> verifyDocSignData(File reqPdfFile) {
        String verifyDocSignDataUrl = this.verifyDocSignDataUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.verifyDocSignData(reqPdfFile, verifyDocSignDataUrl, appKey, appSecret);
    }

    public Map<String, String> verifyDocSignData(File reqPdfFile, String verifyDocSignDataUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (reqPdfFile == null || !reqPdfFile.exists() || verifyDocSignDataUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        String fileName = "file" + System.currentTimeMillis() + RandomUtil.generateString(4);
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("reqPdfData", fileName);
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        HashMap<String, File> files = new HashMap<String, File>();
        files.put(fileName, reqPdfFile);
        Map<String, String> verifyDocSignDataUrlMap = PostUtil.sendPost(verifyDocSignDataUrl, paramMap, files, "utf-8");
        if (verifyDocSignDataUrlMap == null || verifyDocSignDataUrlMap.isEmpty()) {
            map.put("resultCode", "080308");
            map.put("message", "POST\u8bf7\u6c42PDF\u9a8c\u7b7e\u5f02\u5e38");
            return map;
        }
        if (!verifyDocSignDataUrlMap.get("resultCode").equals("200")) {
            map.put("resultCode", verifyDocSignDataUrlMap.get("resultCode"));
            map.put("message", verifyDocSignDataUrlMap.get("message"));
            return map;
        }
        String pdfVerify = null;
        String docBase64 = null;
        try {
            JSONObject json = JSONObject.fromObject((Object)verifyDocSignDataUrlMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            JSONObject data = json.getJSONObject("data");
            pdfVerify = data.getString("pdfVerify");
            if ("false".equals(pdfVerify)) {
                docBase64 = data.getString("docBase64");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080308");
            map.put("message", "POST\u8bf7\u6c42PDF\u9a8c\u7b7e\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42PDF\u6587\u4ef6\u6709\u6548\u6027\u9a8c\u8bc1\u6210\u529f");
        map.put("pdfVerify", pdfVerify);
        map.put("docBase64", docBase64);
        return map;
    }

    public Map<String, String> docManySign(List<PdfDataInfo> pdfDataList, List<SignInfo> signList) {
        String docManySignUrl = this.docManySignUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.docManySign(pdfDataList, signList, docManySignUrl, appKey, appSecret);
    }

    public Map<String, String> docManySign(List<PdfDataInfo> pdfDataList, List<SignInfo> signList, String docManySignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pdfDataList == null || pdfDataList.isEmpty() || signList == null || signList.isEmpty() || docManySignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        Collections.sort(pdfDataList);
        ArrayList<Object> list = new ArrayList<Object>();
        for (PdfDataInfo pdi : pdfDataList) {
            HashMap pdfDataMap = new HashMap();
            if (pdi.getSignSequence() <= 0) {
                map.put("resultCode", "080303");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signSequence(" + pdi.getSignSequence() + ")\u6709\u8bef");
                return map;
            }
            pdfDataMap.put("signSequence", String.valueOf(pdi.getSignSequence()));
            if (pdi.getReqPdfData() == null || pdi.getReqPdfData().trim().equals("")) {
                map.put("resultCode", "080316");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570reqPdfData(" + pdi.getReqPdfData() + ")\u6709\u8bef");
                return map;
            }
            pdfDataMap.put("reqPdfData", pdi.getReqPdfData());
            if (pdi.getUniqueId() == null || pdi.getUniqueId().trim().equals("")) {
                map.put("resultCode", "080309");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570uniqueId(" + pdi.getUniqueId() + ")\u6709\u8bef");
                return map;
            }
            pdfDataMap.put("uniqueId", pdi.getUniqueId());
            list.add(pdfDataMap);
        }
        Collections.sort(signList);
        ArrayList list2 = new ArrayList();
        for (SignInfo si : signList) {
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            if (si.getSignSequence() <= 0) {
                map.put("resultCode", "080303");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signSequence(" + si.getSignSequence() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("signSequence", String.valueOf(si.getSignSequence()));
            if (si.getReqImageData() == null || si.getReqImageData().trim().equals("")) {
                map.put("resultCode", "080310");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570reqImageData(" + si.getReqImageData() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("reqImageData", si.getReqImageData());
            HashMap<String, Object> signInfoMap = new HashMap<String, Object>();
            if (si.getKeyWord() == null || si.getKeyWord().trim().equals("")) {
                map.put("resultCode", "080311");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570keyWord(" + si.getKeyWord() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("keyWord", si.getKeyWord());
            if (si.getKwIndex() == null || si.getKwIndex() == 0) {
                map.put("resultCode", "080304");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570kwIndex(" + si.getKwIndex() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("kwIndex", String.valueOf(si.getKwIndex()));
            if (si.getOffsetTop() != null || si.getOffsetRight() != null) {
                HashMap<String, String> offsetMap = new HashMap<String, String>();
                if (si.getOffsetTop() != null) {
                    offsetMap.put("top", String.valueOf(si.getOffsetTop()));
                }
                if (si.getOffsetRight() != null) {
                    offsetMap.put("right", String.valueOf(si.getOffsetRight()));
                }
                signInfoMap.put("offset", offsetMap);
            }
            if (si.getImageWidth() != null) {
                signInfoMap.put("imageWidth", String.valueOf(si.getImageWidth()));
            }
            if (si.getImageHeight() != null) {
                signInfoMap.put("imageHeight", String.valueOf(si.getImageHeight()));
            }
            signMap.put("signInfoJson", signInfoMap);
            HashMap<String, String> userInfoMap = new HashMap<String, String>();
            if (!"11".equals(si.getSignType()) && !"12".equals(si.getSignType())) {
                map.put("resultCode", "080305");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signType(" + si.getSignType() + ")\u6709\u8bef");
                return map;
            }
            userInfoMap.put("signType", si.getSignType());
            if ("1".equals(si.getSignWay()) || "2".equals(si.getSignWay())) {
                userInfoMap.put("signWay", si.getSignWay());
                if ("1".equals(si.getSignWay())) {
                    if (si.getToken() == null || si.getToken().trim().equals("")) {
                        map.put("resultCode", "080312");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570token(" + si.getToken() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("token", si.getToken());
                    if (si.getPhoneInfo() == null || si.getPhoneInfo().trim().equals("")) {
                        map.put("resultCode", "080313");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570phoneInfo(" + si.getPhoneInfo() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("phoneInfo", si.getPhoneInfo());
                }
                if ("2".equals(si.getSignWay())) {
                    if (si.getUserName() == null || si.getUserName().trim().equals("")) {
                        map.put("resultCode", "080314");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570userName(" + si.getUserName() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("userName", si.getUserName());
                    if (si.getIdCard() == null || si.getIdCard().trim().equals("")) {
                        map.put("resultCode", "080315");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570idCard(" + si.getIdCard() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("idCard", si.getIdCard());
                }
            } else {
                map.put("resultCode", "080306");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signWay(" + si.getSignWay() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("userInfoJson", userInfoMap);
            list2.add(signMap);
        }
        String pdfDataJson = JSONArray.fromObject(list).toString();
        String signJson = JSONArray.fromObject(list2).toString();
        return this.docManySign(pdfDataJson, signJson, docManySignUrl, appKey, appSecret);
    }

    private Map<String, String> docManySign(String pdfDataJson, String signJson, String docManySignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pdfDataJson == null || signJson == null || docManySignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pdfDataJson", pdfDataJson);
        paramMap.put("signJson", signJson);
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        Map<String, String> docManySignMap = PostUtil.sendPost(docManySignUrl, paramMap, "utf-8");
        if (docManySignMap == null || docManySignMap.isEmpty()) {
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        if (!docManySignMap.get("resultCode").equals("200")) {
            map.put("resultCode", docManySignMap.get("resultCode"));
            map.put("message", docManySignMap.get("message"));
            return map;
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)docManySignMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            JSONArray data = json.getJSONArray("data");
            if (data.size() > 0) {
                int i = 0;
                while (i < data.size()) {
                    JSONObject job = data.getJSONObject(i);
                    String docBase64 = job.getString("docBase64");
                    String uniqueId = job.getString("uniqueId");
                    map.put("docBase64_" + uniqueId, docBase64);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u6210\u529f");
        return map;
    }

    public Map<String, String> docManySign2(List<PdfFileInfo> pdfFileList, List<SignInfo> signList) {
        String docManySignUrl = this.docManySignUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.docManySign2(pdfFileList, signList, docManySignUrl, appKey, appSecret);
    }

    public Map<String, String> docManySign2(List<PdfFileInfo> pdfFileList, List<SignInfo> signList, String docManySignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pdfFileList == null || pdfFileList.isEmpty() || signList == null || signList.isEmpty() || docManySignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        Collections.sort(pdfFileList);
        HashMap<String, File> files = new HashMap<String, File>();
        ArrayList<Object> list = new ArrayList<Object>();
        for (PdfFileInfo pfi : pdfFileList) {
            HashMap pdfDataMap = new HashMap();
            if (pfi.getSignSequence() <= 0) {
                map.put("resultCode", "080303");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signSequence(" + pfi.getSignSequence() + ")\u6709\u8bef");
                return map;
            }
            pdfDataMap.put("signSequence", String.valueOf(pfi.getSignSequence()));
            if (pfi.getUniqueId() == null || pfi.getUniqueId().trim().equals("")) {
                map.put("resultCode", "080309");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570uniqueId(" + pfi.getUniqueId() + ")\u6709\u8bef");
                return map;
            }
            pdfDataMap.put("uniqueId", pfi.getUniqueId());
            if (pfi.getFile() == null || !pfi.getFile().exists()) {
                map.put("resultCode", "080317");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570file\u6709\u8bef");
                return map;
            }
            String fileName = "file" + System.currentTimeMillis() + RandomUtil.generateString(4);
            pdfDataMap.put("reqPdfData", fileName);
            files.put(fileName, pfi.getFile());
            list.add(pdfDataMap);
        }
        Collections.sort(signList);
        ArrayList list2 = new ArrayList();
        for (SignInfo si : signList) {
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            if (si.getSignSequence() <= 0) {
                map.put("resultCode", "080303");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signSequence(" + si.getSignSequence() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("signSequence", String.valueOf(si.getSignSequence()));
            if (si.getReqImageData() == null || si.getReqImageData().trim().equals("")) {
                map.put("resultCode", "080310");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570reqImageData(" + si.getReqImageData() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("reqImageData", si.getReqImageData());
            HashMap<String, Object> signInfoMap = new HashMap<String, Object>();
            if (si.getKeyWord() == null || si.getKeyWord().trim().equals("")) {
                map.put("resultCode", "080311");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570keyWord(" + si.getKeyWord() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("keyWord", si.getKeyWord());
            if (si.getKwIndex() == null || si.getKwIndex() == 0) {
                map.put("resultCode", "080304");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570kwIndex(" + si.getKwIndex() + ")\u6709\u8bef");
                return map;
            }
            signInfoMap.put("kwIndex", String.valueOf(si.getKwIndex()));
            if (si.getOffsetTop() != null || si.getOffsetRight() != null) {
                HashMap<String, String> offsetMap = new HashMap<String, String>();
                if (si.getOffsetTop() != null) {
                    offsetMap.put("top", String.valueOf(si.getOffsetTop()));
                }
                if (si.getOffsetRight() != null) {
                    offsetMap.put("right", String.valueOf(si.getOffsetRight()));
                }
                signInfoMap.put("offset", offsetMap);
            }
            if (si.getImageWidth() != null) {
                signInfoMap.put("imageWidth", String.valueOf(si.getImageWidth()));
            }
            if (si.getImageHeight() != null) {
                signInfoMap.put("imageHeight", String.valueOf(si.getImageHeight()));
            }
            signMap.put("signInfoJson", signInfoMap);
            HashMap<String, String> userInfoMap = new HashMap<String, String>();
            if (!"11".equals(si.getSignType()) && !"12".equals(si.getSignType())) {
                map.put("resultCode", "080305");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signType(" + si.getSignType() + ")\u6709\u8bef");
                return map;
            }
            userInfoMap.put("signType", si.getSignType());
            if ("1".equals(si.getSignWay()) || "2".equals(si.getSignWay())) {
                userInfoMap.put("signWay", si.getSignWay());
                if ("1".equals(si.getSignWay())) {
                    if (si.getToken() == null || si.getToken().trim().equals("")) {
                        map.put("resultCode", "080312");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570token(" + si.getToken() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("token", si.getToken());
                    if (si.getPhoneInfo() == null || si.getPhoneInfo().trim().equals("")) {
                        map.put("resultCode", "080313");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570phoneInfo(" + si.getPhoneInfo() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("phoneInfo", si.getPhoneInfo());
                }
                if ("2".equals(si.getSignWay())) {
                    if (si.getUserName() == null || si.getUserName().trim().equals("")) {
                        map.put("resultCode", "080314");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570userName(" + si.getUserName() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("userName", si.getUserName());
                    if (si.getIdCard() == null || si.getIdCard().trim().equals("")) {
                        map.put("resultCode", "080315");
                        map.put("message", "\u4f20\u5165\u7684\u53c2\u6570idCard(" + si.getIdCard() + ")\u6709\u8bef");
                        return map;
                    }
                    userInfoMap.put("idCard", si.getIdCard());
                }
            } else {
                map.put("resultCode", "080306");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signWay(" + si.getSignWay() + ")\u6709\u8bef");
                return map;
            }
            signMap.put("userInfoJson", userInfoMap);
            list2.add(signMap);
        }
        String pdfDataJson = JSONArray.fromObject(list).toString();
        String signJson = JSONArray.fromObject(list2).toString();
        return this.docManySign(pdfDataJson, files, signJson, docManySignUrl, appKey, appSecret);
    }

    private Map<String, String> docManySign(String pdfDataJson, Map<String, File> files, String signJson, String docManySignUrl, String appKey, String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pdfDataJson == null || signJson == null || docManySignUrl == null || appKey == null || appSecret == null) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pdfDataJson", pdfDataJson);
        paramMap.put("signJson", signJson);
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        Map<String, String> docManySignMap = PostUtil.sendPost(docManySignUrl, paramMap, files, "utf-8");
        if (docManySignMap == null || docManySignMap.isEmpty()) {
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        if (!docManySignMap.get("resultCode").equals("200")) {
            map.put("resultCode", docManySignMap.get("resultCode"));
            map.put("message", docManySignMap.get("message"));
            return map;
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)docManySignMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            JSONArray data = json.getJSONArray("data");
            if (data.size() > 0) {
                int i = 0;
                while (i < data.size()) {
                    JSONObject job = data.getJSONObject(i);
                    String docBase64 = job.getString("docBase64");
                    String uniqueId = job.getString("uniqueId");
                    map.put("docBase64_" + uniqueId, docBase64);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080307");
            map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42PDF\u7b7e\u540d\u6210\u529f");
        return map;
    }

    public Map<String, String> queryStatistics(Rate rate, QueryCondition_certRecord condition) {
        String startTime = condition.getStartTime();
        String endTime = condition.getEndTime();
        String userName = condition.getUserName();
        String idCard = condition.getIdCard();
        String signType = condition.getSignType();
        String result = condition.getResult();
        String model = condition.getModel();
        String deviceID = condition.getDeviceID();
        return this.queryStatistics(rate, startTime, endTime, userName, idCard, signType, result, model, deviceID);
    }

    private Map<String, String> queryStatistics(Rate rate, String startTime, String endTime, String userName, String idCard, String signType, String result, String model, String deviceID) {
        String queryStatisticsUrl = this.queryStatisticsUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.queryStatistics(rate, startTime, endTime, userName, idCard, signType, result, model, deviceID, queryStatisticsUrl, appKey, appSecret);
    }

    private Map<String, String> queryStatistics(Rate rate, String startTime, String endTime, String userName, String idCard, String signType, String result, String model, String deviceID, String queryStatisticsUrl, String appKey, String appSecret) {
        Date date;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryStatisticsUrl == null || queryStatisticsUrl.trim().equals("") || appKey == null || appKey.trim().equals("") || appSecret == null || appSecret.trim().equals("")) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        queryStatisticsUrl = queryStatisticsUrl.trim();
        appKey = appKey.trim();
        appSecret = appSecret.trim();
        if (rate == null) {
            map.put("resultCode", "080318");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570rate\u6709\u8bef");
            return map;
        }
        if (startTime == null || startTime.trim().equals("")) {
            startTime = null;
        } else {
            if ((startTime = startTime.trim()).length() != 19) {
                map.put("resultCode", "080319");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570startTime\u6709\u8bef");
                return map;
            }
            try {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startTime);
                startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            }
            catch (Exception e) {
                e.printStackTrace();
                map.put("resultCode", "080319");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570startTime\u6709\u8bef");
                return map;
            }
        }
        if (endTime == null || endTime.trim().equals("")) {
            endTime = null;
        } else {
            if ((endTime = endTime.trim()).length() != 19) {
                map.put("resultCode", "080320");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570endTime\u6709\u8bef");
                return map;
            }
            try {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime);
                endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            }
            catch (Exception e) {
                e.printStackTrace();
                map.put("resultCode", "080320");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570endTime\u6709\u8bef");
                return map;
            }
        }
        userName = userName == null || userName.trim().equals("") ? null : userName.trim();
        idCard = idCard == null || idCard.trim().equals("") ? null : idCard.trim();
        if (signType == null || signType.trim().equals("")) {
            signType = null;
        } else if (!"11".equals(signType = signType.trim()) && !"12".equals(signType)) {
            map.put("resultCode", "080327");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signType\u6709\u8bef");
            return map;
        }
        if (result == null || result.trim().equals("")) {
            result = null;
        } else if (!"0".equals(result = result.trim()) && !"1".equals(result)) {
            map.put("resultCode", "080328");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570result\u6709\u8bef");
            return map;
        }
        model = model == null || model.trim().equals("") ? null : model.trim();
        deviceID = deviceID == null || deviceID.trim().equals("") ? null : deviceID.trim();
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (startTime != null) {
            paramMap.put("startTime", startTime);
        }
        if (endTime != null) {
            paramMap.put("endTime", endTime);
        }
        if (userName != null) {
            paramMap.put("userName", userName);
        }
        if (idCard != null) {
            paramMap.put("idCard", idCard);
        }
        if (signType != null) {
            paramMap.put("signType", signType);
        }
        if (result != null) {
            paramMap.put("result", result);
        }
        if (model != null) {
            paramMap.put("model", model);
        }
        if (deviceID != null) {
            paramMap.put("deviceID", deviceID);
        }
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        Map<String, String> queryStatisticsMap = PostUtil.sendPost(queryStatisticsUrl, paramMap, "utf-8");
        if (queryStatisticsMap == null || queryStatisticsMap.isEmpty()) {
            map.put("resultCode", "080321");
            map.put("message", "POST\u8bf7\u6c42\u67e5\u8be2\u7edf\u8ba1\u5f02\u5e38");
            return map;
        }
        if (!queryStatisticsMap.get("resultCode").equals("200")) {
            map.put("resultCode", queryStatisticsMap.get("resultCode"));
            map.put("message", queryStatisticsMap.get("message"));
            return map;
        }
        try {
            JSONObject json = JSONObject.fromObject((Object)queryStatisticsMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            String logType = json.getString("logType");
            String sum = json.getString("sum");
            String successRate = json.getString("success_rate");
            String success = json.getString("success");
            String failRate = json.getString("fail_rate");
            String fail = json.getString("fail");
            rate.setLogType(logType);
            rate.setSum(new BigInteger(sum));
            rate.setSuccessRate(successRate);
            rate.setSuccess(new BigDecimal(success));
            rate.setFailRate(failRate);
            rate.setFail(new BigDecimal(fail));
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080321");
            map.put("message", "POST\u8bf7\u6c42\u67e5\u8be2\u7edf\u8ba1\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42\u67e5\u8be2\u7edf\u8ba1\u7b7e\u540d\u60c5\u51b5\u6210\u529f");
        return map;
    }

    public Map<String, String> queryRecord(PageBean_certRecord pageBean, QueryCondition_certRecord condition) {
        Integer pageNum = condition.getPageNum();
        Integer pageSize = condition.getPageSize();
        String startTime = condition.getStartTime();
        String endTime = condition.getEndTime();
        String userName = condition.getUserName();
        String idCard = condition.getIdCard();
        String signType = condition.getSignType();
        String result = condition.getResult();
        String model = condition.getModel();
        String deviceID = condition.getDeviceID();
        return this.queryRecord(pageBean, pageNum, pageSize, startTime, endTime, userName, idCard, signType, result, model, deviceID);
    }

    private Map<String, String> queryRecord(PageBean_certRecord pageBean, Integer pageNum, Integer pageSize, String startTime, String endTime, String userName, String idCard, String signType, String result, String model, String deviceID) {
        String queryRecordUrl = this.queryRecordUrl;
        String appKey = this.appKey;
        String appSecret = this.appSecret;
        return this.queryRecord(pageBean, pageNum, pageSize, startTime, endTime, userName, idCard, signType, result, model, deviceID, queryRecordUrl, appKey, appSecret);
    }

    private Map<String, String> queryRecord(PageBean_certRecord pageBean, Integer pageNum, Integer pageSize, String startTime, String endTime, String userName, String idCard, String signType, String result, String model, String deviceID, String queryRecordUrl, String appKey, String appSecret) {
        Date date;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryRecordUrl == null || queryRecordUrl.trim().equals("") || appKey == null || appKey.trim().equals("") || appSecret == null || appSecret.trim().equals("")) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        queryRecordUrl = queryRecordUrl.trim();
        appKey = appKey.trim();
        appSecret = appSecret.trim();
        if (pageBean == null) {
            map.put("resultCode", "080322");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570pageBean\u6709\u8bef");
            return map;
        }
        List<CertRecord> certRecordList = pageBean.getRecordList();
        if (certRecordList == null || !certRecordList.isEmpty()) {
            pageBean.setRecordList(null);
        }
        if (pageNum == null || pageNum <= 0) {
            map.put("resultCode", "080324");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570pageNum\u6709\u8bef");
            return map;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = null;
        } else if (pageSize < 10 || pageSize > 40) {
            map.put("resultCode", "080325");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570pageSize\u6709\u8bef");
            return map;
        }
        if (startTime == null || startTime.trim().equals("")) {
            startTime = null;
        } else {
            if ((startTime = startTime.trim()).length() != 19) {
                map.put("resultCode", "080319");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570startTime\u6709\u8bef");
                return map;
            }
            try {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startTime);
                startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            }
            catch (Exception e) {
                e.printStackTrace();
                map.put("resultCode", "080319");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570startTime\u6709\u8bef");
                return map;
            }
        }
        if (endTime == null || endTime.trim().equals("")) {
            endTime = null;
        } else {
            if ((endTime = endTime.trim()).length() != 19) {
                map.put("resultCode", "080320");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570endTime\u6709\u8bef");
                return map;
            }
            try {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime);
                endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            }
            catch (Exception e) {
                e.printStackTrace();
                map.put("resultCode", "080320");
                map.put("message", "\u4f20\u5165\u7684\u53c2\u6570endTime\u6709\u8bef");
                return map;
            }
        }
        userName = userName == null || userName.trim().equals("") ? null : userName.trim();
        idCard = idCard == null || idCard.trim().equals("") ? null : idCard.trim();
        if (signType == null || signType.trim().equals("")) {
            signType = null;
        } else if (!"11".equals(signType = signType.trim()) && !"12".equals(signType)) {
            map.put("resultCode", "080327");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570signType\u6709\u8bef");
            return map;
        }
        if (result == null || result.trim().equals("")) {
            result = null;
        } else if (!"0".equals(result = result.trim()) && !"1".equals(result)) {
            map.put("resultCode", "080328");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570result\u6709\u8bef");
            return map;
        }
        model = model == null || model.trim().equals("") ? null : model.trim();
        deviceID = deviceID == null || deviceID.trim().equals("") ? null : deviceID.trim();
        String nonce = RandomUtil.generateString(16);
        String time = String.valueOf(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (pageNum != null) {
            paramMap.put("pageNum", String.valueOf(pageNum));
        }
        if (pageSize != null) {
            paramMap.put("pageSize", String.valueOf(pageSize));
        }
        if (startTime != null) {
            paramMap.put("startTime", startTime);
        }
        if (endTime != null) {
            paramMap.put("endTime", endTime);
        }
        if (userName != null) {
            paramMap.put("userName", userName);
        }
        if (idCard != null) {
            paramMap.put("idCard", idCard);
        }
        if (signType != null) {
            paramMap.put("signType", signType);
        }
        if (result != null) {
            paramMap.put("result", result);
        }
        if (model != null) {
            paramMap.put("model", model);
        }
        if (deviceID != null) {
            paramMap.put("deviceID", deviceID);
        }
        paramMap.put("appKey", appKey);
        paramMap.put("nonce", nonce);
        paramMap.put("time", time);
        String signature = MD5.sign(String.valueOf(appSecret) + Sort.sortMap(paramMap));
        paramMap.put("signature", signature);
        Map<String, String> queryRecordMap = PostUtil.sendPost(queryRecordUrl, paramMap, "utf-8");
        if (queryRecordMap == null || queryRecordMap.isEmpty()) {
            map.put("resultCode", "080326");
            map.put("message", "POST\u8bf7\u6c42\u67e5\u8be2\u8bb0\u5f55\u5f02\u5e38");
            return map;
        }
        if (!queryRecordMap.get("resultCode").equals("200")) {
            map.put("resultCode", queryRecordMap.get("resultCode"));
            map.put("message", queryRecordMap.get("message"));
            return map;
        }
        try {
            JSONArray arr;
            String logList_json;
            JSONObject json = JSONObject.fromObject((Object)queryRecordMap.get("message"));
            String resultCode = json.getString("rtnCode");
            if (!resultCode.equals("200")) {
                map.put("resultCode", resultCode);
                map.put("message", json.getString("rtnMsg"));
                return map;
            }
            pageBean.setPageSize(json.get("pageSize") == null ? null : Integer.valueOf(json.getInt("pageSize")));
            pageBean.setCurrentPage(json.get("pageNum") == null ? null : Integer.valueOf(json.getInt("pageNum")));
            pageBean.setRecordCount(json.get("recordCount") == null ? null : Integer.valueOf(json.getInt("recordCount")));
            pageBean.setPageCount(json.get("pageCount") == null ? null : Integer.valueOf(json.getInt("pageCount")));
            String string = logList_json = json.get("logList") == null ? null : json.getString("logList");
            if (logList_json != null && !logList_json.trim().equals("") && (arr = JSONArray.fromObject((Object)logList_json)).size() > 0) {
                ArrayList<CertRecord> certRecordList2 = new ArrayList<CertRecord>();
                int i = 0;
                while (i < arr.size()) {
                    JSONObject obj = arr.getJSONObject(i);
                    JSONObject log_json = obj.getJSONObject("log");
                    String userName2 = log_json.getString("userName");
                    String idCard2 = log_json.getString("idCard");
                    String signType2 = log_json.get("signType") == null ? "" : log_json.getString("signType");
                    String result2 = log_json.getString("result");
                    String signTime = log_json.getString("signTime");
                    String signCertSn = log_json.getString("signCertSn");
                    String phoneInfo = log_json.getString("phoneInfo");
                    String buildId = log_json.get("buildId") == null ? "" : log_json.getString("buildId");
                    String model2 = log_json.get("model") == null ? "" : log_json.getString("model");
                    String deviceID2 = log_json.get("deviceID") == null ? "" : log_json.getString("deviceID");
                    int sequence = Integer.parseInt(log_json.getString("sequence"));
                    CertRecord certRecord = new CertRecord();
                    certRecord.setUserName(userName2);
                    certRecord.setIdCard(idCard2);
                    certRecord.setSignType(signType2);
                    certRecord.setResult(result2);
                    certRecord.setOperateTime(signTime);
                    certRecord.setSignCertSn(signCertSn);
                    certRecord.setPhoneInfo(phoneInfo);
                    certRecord.setBuildId(buildId);
                    certRecord.setModel(model2);
                    certRecord.setDeviceID(deviceID2);
                    certRecord.setSequence(sequence);
                    certRecordList2.add(certRecord);
                    ++i;
                }
                Collections.sort(certRecordList2);
                pageBean.setRecordList(certRecordList2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080326");
            map.put("message", "POST\u8bf7\u6c42\u67e5\u8be2\u8bb0\u5f55\u5f02\u5e38");
            return map;
        }
        map.put("resultCode", "200");
        map.put("message", "POST\u8bf7\u6c42\u67e5\u8be2\u7b7e\u540d\u8bb0\u5f55\u6210\u529f");
        return map;
    }

    public Map<String, String> verifyDocSignDatas(List<PdfDataInfo2> pdfDataList) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pdfDataList == null || pdfDataList.isEmpty()) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        ArrayList<PdfDataInfo2> list = new ArrayList<PdfDataInfo2>();
        for (PdfDataInfo2 pdi : pdfDataList) {
            String reqPdfData = pdi.getReqPdfData();
            Map<String, String> returnMap = this.verifyDocSignData(reqPdfData);
            pdi.setCode(returnMap.get("resultCode"));
            pdi.setMsg(returnMap.get("message"));
            if ("true".equals(returnMap.get("pdfVerify"))) {
                pdi.setVerify(true);
            } else {
                pdi.setVerify(false);
            }
            pdi.setDocBase64(returnMap.get("docBase64"));
            list.add(pdi);
        }
        pdfDataList = list;
        Collections.sort(pdfDataList);
        map.put("resultCode", "200");
        map.put("message", "\u6279\u91cf\u9a8c\u7b7e\u6210\u529f");
        return map;
    }

    public Map<String, String> verifyDocSignDatas2(List<PdfFileInfo2> pdfFileList) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (pdfFileList == null || pdfFileList.isEmpty()) {
            map.put("resultCode", "080302");
            map.put("message", "\u4f20\u5165\u7684\u53c2\u6570\u6709\u8bef");
            return map;
        }
        ArrayList<PdfFileInfo2> list = new ArrayList<PdfFileInfo2>();
        for (PdfFileInfo2 pfi : pdfFileList) {
            File reqPdfFile = pfi.getFile();
            Map<String, String> returnMap = this.verifyDocSignData(reqPdfFile);
            pfi.setCode(returnMap.get("resultCode"));
            pfi.setMsg(returnMap.get("message"));
            if ("true".equals(returnMap.get("pdfVerify"))) {
                pfi.setVerify(true);
            } else {
                pfi.setVerify(false);
            }
            pfi.setDocBase64(returnMap.get("docBase64"));
            list.add(pfi);
        }
        pdfFileList = list;
        Collections.sort(pdfFileList);
        map.put("resultCode", "200");
        map.put("message", "\u6279\u91cf\u9a8c\u7b7e\u6210\u529f");
        return map;
    }
}

