/*
 * Decompiled with CFR 0.152.
 */
package org.aheca.cn.seal.service;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.aheca.cn.seal.service.HttpsUtil;

public class PostUtil {
    public static Map<String, String> sendPost(String url0, Map<String, String> params, String encode) {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            if (url0.startsWith("https://")) {
                Map<String, String> map2 = new HttpsUtil().sendPost(url0, "POST", params, encode);
                return map2;
            }
            if (params == null || params.isEmpty()) {
                map.put("resultCode", "080402");
                map.put("message", "\u672a\u53d1\u9001\u6709\u6548\u6570\u636e");
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                stringBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), encode)).append("&");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            byte[] myData = stringBuilder.toString().getBytes(encode);
            URL url = new URL(url0);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(60000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", String.valueOf(myData.length));
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(myData, 0, myData.length);
            outputStream.close();
            int responseCode = connection.getResponseCode();
            inputStream = responseCode == 200 ? connection.getInputStream() : connection.getErrorStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            String result = null;
            if (inputStream != null) {
                try {
                    int len;
                    while ((len = inputStream.read(data)) != -1) {
                        byteArrayOutputStream.write(data, 0, len);
                    }
                    result = new String(byteArrayOutputStream.toByteArray(), encode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            connection.disconnect();
            if (responseCode != 200) {
                map.put("resultCode", "080403");
                map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + responseCode + ")");
                System.out.println("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + responseCode + "):" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            if (result.contains("</html>") || result.contains("</HTML>")) {
                map.put("resultCode", "080404");
                map.put("message", "\u670d\u52a1\u5668\u5f02\u5e38");
                System.out.println("\u670d\u52a1\u5668\u5f02\u5e38:" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            map.put("resultCode", "200");
            map.put("message", result);
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (SocketTimeoutException ex) {
            ex.printStackTrace();
            map.put("resultCode", "080405");
            map.put("message", "\u8fde\u63a5\u8d85\u65f6");
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080406");
            map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage());
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Map<String, String> sendPost(String actionUrl, Map<String, String> params, Map<String, File> files, String encode) {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream is = null;
        try {
            if (actionUrl.startsWith("https://")) {
                Map<String, String> map2 = new HttpsUtil().sendPost(actionUrl, "POST", params, encode);
                return map2;
            }
            if (params == null || params.isEmpty()) {
                map.put("resultCode", "080402");
                map.put("message", "\u672a\u53d1\u9001\u6709\u6548\u6570\u636e");
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            String BOUNDARY = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            String PREFIX = "--";
            String LINEND = "\r\n";
            String MULTIPART_FROM_DATA = "multipart/form-data";
            String CHARSET = "UTF-8";
            URL url = new URL(actionUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(60000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("connection", "keep-alive");
            connection.setRequestProperty("Charsert", "UTF-8");
            connection.setRequestProperty("Content-Type", String.valueOf(MULTIPART_FROM_DATA) + ";boundary=" + BOUNDARY);
            connection.connect();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                stringBuilder.append(PREFIX);
                stringBuilder.append(BOUNDARY);
                stringBuilder.append(LINEND);
                stringBuilder.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
                stringBuilder.append("Content-Type: text/plain; charset=" + CHARSET + LINEND);
                stringBuilder.append("Content-Transfer-Encoding: 8bit" + LINEND);
                stringBuilder.append(LINEND);
                stringBuilder.append(entry.getValue());
                stringBuilder.append(LINEND);
            }
            byte[] myData = stringBuilder.toString().getBytes(encode);
            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            outputStream.write(myData, 0, myData.length);
            outputStream.flush();
            if (files != null && !files.isEmpty()) {
                for (Map.Entry<String, File> entry : files.entrySet()) {
                    if (!entry.getValue().exists()) continue;
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append(PREFIX);
                    sb1.append(BOUNDARY);
                    sb1.append(LINEND);
                    sb1.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + entry.getValue().getName() + "\"" + LINEND);
                    sb1.append("Content-Type: " + PostUtil.getContentType(entry.getValue()) + "; charset=" + CHARSET + LINEND);
                    sb1.append("Content-Transfer-Encoding: binary" + LINEND);
                    sb1.append(LINEND);
                    outputStream.write(sb1.toString().getBytes(encode));
                    is = new FileInputStream(entry.getValue());
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = is.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                    is.close();
                    outputStream.write(LINEND.getBytes(encode));
                    outputStream.flush();
                }
            }
            byte[] end_data = (String.valueOf(PREFIX) + BOUNDARY + PREFIX + LINEND).getBytes(encode);
            outputStream.write(end_data);
            outputStream.flush();
            int responseCode = connection.getResponseCode();
            inputStream = responseCode == 200 ? connection.getInputStream() : connection.getErrorStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            String result = null;
            if (inputStream != null) {
                try {
                    int len;
                    while ((len = inputStream.read(data)) != -1) {
                        byteArrayOutputStream.write(data, 0, len);
                    }
                    result = new String(byteArrayOutputStream.toByteArray(), encode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            outputStream.close();
            connection.disconnect();
            if (responseCode != 200) {
                map.put("resultCode", "080403");
                map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + responseCode + ")");
                System.out.println("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + responseCode + "):" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            if (result.contains("</html>") || result.contains("</HTML>")) {
                map.put("resultCode", "080404");
                map.put("message", "\u670d\u52a1\u5668\u5f02\u5e38");
                System.out.println("\u670d\u52a1\u5668\u5f02\u5e38:" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            map.put("resultCode", "200");
            map.put("message", result);
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (SocketTimeoutException ex) {
            ex.printStackTrace();
            map.put("resultCode", "080405");
            map.put("message", "\u8fde\u63a5\u8d85\u65f6");
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080406");
            map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage());
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getContentType(File file) throws Exception {
        String streamContentType = "application/octet-stream";
        String imageContentType = "";
        ImageInputStream image = null;
        try {
            String fileName = file.getName();
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            if ("pdf".equalsIgnoreCase(extension)) {
                return "application/pdf";
            }
            if ("png".equalsIgnoreCase(extension)) {
                return "image/png";
            }
            if ("jpg".equalsIgnoreCase(extension) || "jpeg".equalsIgnoreCase(extension) || "jpe".equalsIgnoreCase(extension)) {
                return "image/jpeg";
            }
            if ("gif".equalsIgnoreCase(extension)) {
                return "image/gif";
            }
            image = ImageIO.createImageInputStream(file);
            if (image == null) {
                String string = streamContentType;
                return string;
            }
            Iterator<ImageReader> it = ImageIO.getImageReaders(image);
            if (it.hasNext()) {
                String string = imageContentType = "image/" + it.next().getFormatName();
                return string;
            }
        }
        catch (IOException e) {
            System.out.println("method getContentType failed:" + e.getMessage());
            throw new Exception(e);
        }
        finally {
            try {
                if (image != null) {
                    image.close();
                }
            }
            catch (IOException e) {
                System.out.println("ImageInputStream close failed:" + e.getMessage());
                throw new Exception(e);
            }
        }
        return streamContentType;
    }
}

