/*
 * Decompiled with CFR 0.152.
 */
package org.aheca.cn.seal.service;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.aheca.cn.seal.service.PostUtil;
import sun.net.www.protocol.https.Handler;

public class HttpsUtil {
    X509TrustManager xtm = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    public Map<String, String> sendPost(String url0, String requestMethod, Map<String, String> params, String encode) {
        Map<String, String> urlInfoMap = this.getUrlInfo(url0);
        final String requestIP = urlInfoMap.get("requestIP");
        String requestPort = urlInfoMap.get("requestPort");
        String requestPathname = urlInfoMap.get("requestPathname");
        HashMap<String, String> map = new HashMap<String, String>();
        String requestUrl = "https://" + requestIP + ":" + requestPort + requestPathname;
        InputStream is = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            if (params == null || params.isEmpty()) {
                map.put("resultCode", "080402");
                map.put("message", "\u672a\u53d1\u9001\u6709\u6548\u6570\u636e");
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                stringBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), encode)).append("&");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            byte[] myData = stringBuilder.toString().getBytes(encode);
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManager[] tm = new TrustManager[]{this.xtm};
            sslContext.init(new KeyManager[0], tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(null, requestUrl, new Handler());
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            if (requestMethod != null && !requestMethod.equals("")) {
                conn.setRequestMethod(requestMethod);
            } else {
                conn.setRequestMethod("GET");
            }
            conn.setSSLSocketFactory(ssf);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    if (hostname.equals("localhost")) {
                        return true;
                    }
                    if (hostname.equals("online.aheca.cn")) {
                        return true;
                    }
                    if (hostname.equals(requestIP)) {
                        return true;
                    }
                    int index = hostname.indexOf(".");
                    String hostname2 = hostname.substring(index, hostname.length());
                    return hostname2.equals(".aheca.cn");
                }
            });
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(myData.length));
            conn.connect();
            OutputStream os = conn.getOutputStream();
            os.write(myData, 0, myData.length);
            os.close();
            os.flush();
            int code = conn.getResponseCode();
            is = code == 200 ? conn.getInputStream() : conn.getErrorStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            String result = null;
            if (is != null) {
                try {
                    int len;
                    while ((len = is.read(data)) != -1) {
                        byteArrayOutputStream.write(data, 0, len);
                    }
                    result = new String(byteArrayOutputStream.toByteArray(), encode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            conn.disconnect();
            if (code != 200) {
                map.put("resultCode", "080403");
                map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + code + ")");
                System.out.println("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + code + "):" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            if (result.contains("</html>") || result.contains("</HTML>")) {
                map.put("resultCode", "080404");
                map.put("message", "\u670d\u52a1\u5668\u5f02\u5e38");
                System.out.println("\u670d\u52a1\u5668\u5f02\u5e38:" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            map.put("resultCode", "200");
            map.put("message", result);
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (SocketTimeoutException ex) {
            ex.printStackTrace();
            map.put("resultCode", "080405");
            map.put("message", "\u8fde\u63a5\u8d85\u65f6");
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080406");
            map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage());
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Map<String, String> sendPost(String actionUrl, String requestMethod, Map<String, String> params, Map<String, File> files, String encode) {
        Map<String, String> urlInfoMap = this.getUrlInfo(actionUrl);
        final String requestIP = urlInfoMap.get("requestIP");
        String requestPort = urlInfoMap.get("requestPort");
        String requestPathname = urlInfoMap.get("requestPathname");
        HashMap<String, String> map = new HashMap<String, String>();
        String requestUrl = "https://" + requestIP + ":" + requestPort + requestPathname;
        InputStream is = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            if (params == null || params.isEmpty()) {
                map.put("resultCode", "080402");
                map.put("message", "\u672a\u53d1\u9001\u6709\u6548\u6570\u636e");
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            String BOUNDARY = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            String PREFIX = "--";
            String LINEND = "\r\n";
            String MULTIPART_FROM_DATA = "multipart/form-data";
            String CHARSET = "UTF-8";
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManager[] tm = new TrustManager[]{this.xtm};
            sslContext.init(new KeyManager[0], tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(null, requestUrl, new Handler());
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            if (requestMethod != null && !requestMethod.equals("")) {
                conn.setRequestMethod(requestMethod);
            } else {
                conn.setRequestMethod("GET");
            }
            conn.setSSLSocketFactory(ssf);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    if (hostname.equals("localhost")) {
                        return true;
                    }
                    if (hostname.equals("online.aheca.cn")) {
                        return true;
                    }
                    if (hostname.equals(requestIP)) {
                        return true;
                    }
                    int index = hostname.indexOf(".");
                    String hostname2 = hostname.substring(index, hostname.length());
                    return hostname2.equals(".aheca.cn");
                }
            });
            conn.setRequestProperty("connection", "keep-alive");
            conn.setRequestProperty("Charsert", "UTF-8");
            conn.setRequestProperty("Content-Type", String.valueOf(MULTIPART_FROM_DATA) + ";boundary=" + BOUNDARY);
            conn.connect();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                stringBuilder.append(PREFIX);
                stringBuilder.append(BOUNDARY);
                stringBuilder.append(LINEND);
                stringBuilder.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
                stringBuilder.append("Content-Type: text/plain; charset=" + CHARSET + LINEND);
                stringBuilder.append("Content-Transfer-Encoding: 8bit" + LINEND);
                stringBuilder.append(LINEND);
                stringBuilder.append(entry.getValue());
                stringBuilder.append(LINEND);
            }
            byte[] myData = stringBuilder.toString().getBytes(encode);
            DataOutputStream os = new DataOutputStream(conn.getOutputStream());
            os.write(myData, 0, myData.length);
            os.flush();
            if (files != null && !files.isEmpty()) {
                for (Map.Entry<String, File> entry : files.entrySet()) {
                    if (!entry.getValue().exists()) continue;
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append(PREFIX);
                    sb1.append(BOUNDARY);
                    sb1.append(LINEND);
                    sb1.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + entry.getValue().getName() + "\"" + LINEND);
                    sb1.append("Content-Type: " + PostUtil.getContentType(entry.getValue()) + "; charset=" + CHARSET + LINEND);
                    sb1.append("Content-Transfer-Encoding: binary" + LINEND);
                    sb1.append(LINEND);
                    os.write(sb1.toString().getBytes(encode));
                    is = new FileInputStream(entry.getValue());
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = is.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                    is.close();
                    os.write(LINEND.getBytes(encode));
                    os.flush();
                }
            }
            byte[] end_data = (String.valueOf(PREFIX) + BOUNDARY + PREFIX + LINEND).getBytes(encode);
            os.write(end_data);
            os.flush();
            int code = conn.getResponseCode();
            is = code == 200 ? conn.getInputStream() : conn.getErrorStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            String result = null;
            if (is != null) {
                try {
                    int len;
                    while ((len = is.read(data)) != -1) {
                        byteArrayOutputStream.write(data, 0, len);
                    }
                    result = new String(byteArrayOutputStream.toByteArray(), encode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            os.close();
            conn.disconnect();
            if (code != 200) {
                map.put("resultCode", "080403");
                map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + code + ")");
                System.out.println("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25responseCode(" + code + "):" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            if (result.contains("</html>") || result.contains("</HTML>")) {
                map.put("resultCode", "080404");
                map.put("message", "\u670d\u52a1\u5668\u5f02\u5e38");
                System.out.println("\u670d\u52a1\u5668\u5f02\u5e38:" + result);
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            map.put("resultCode", "200");
            map.put("message", result);
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (SocketTimeoutException ex) {
            ex.printStackTrace();
            map.put("resultCode", "080405");
            map.put("message", "\u8fde\u63a5\u8d85\u65f6");
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("resultCode", "080406");
            map.put("message", "\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage());
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private Map<String, String> getUrlInfo(String url0) {
        HashMap<String, String> map = new HashMap<String, String>();
        String requestIP = "";
        String requestPort = "";
        String requestPathname = "";
        if (url0.indexOf("https://") != -1) {
            String url1 = url0.split("https://")[1];
            if (url1.indexOf(":") != -1) {
                requestIP = url1.split(":")[0];
                String url2 = url1.split(":")[1];
                int index = url2.indexOf("/");
                if (index != -1) {
                    requestPort = url2.substring(0, index);
                    requestPathname = url2.substring(index, url2.length());
                } else {
                    requestPort = url2;
                }
            } else {
                requestPort = "80";
                int index = url1.indexOf("/");
                if (index != -1) {
                    requestIP = url1.substring(0, index);
                    requestPathname = url1.substring(index, url1.length());
                } else {
                    requestIP = url1;
                }
            }
        }
        map.put("requestIP", requestIP);
        map.put("requestPort", requestPort);
        map.put("requestPathname", requestPathname);
        return map;
    }
}

