var depttree = $("#deptId");
var mainform = $("#mainform");
var baseaction = "sys/baseuser";
$(function () {
    $("#orgId").combotree({
        url: "sys/baseorg/tree",
        parentField: "pid",
        onChange: function (newValue, oldValue) {
            $.ajax({
                type: 'get',
                url: "sys/basedept/tree?orgId=" + newValue,
                dataType: 'json',
                success: function(resp) {
                    if(resp) {
                        depttree.combotree('loadData', buildTree(resp));
                    }
                }
            });
        }
    });
    var params = Frame.getDialogParams();
    if (params.id) {
        mainform.form('load', baseaction + "/findone?id=" + params.id);
    } else {
        mainform.form('load', params);
    }
});

function buildTree(data){
    var d = [];
    var map = {};

    while(data.length > 0) {
        var first = data.shift();
        map[first.id] = first;
        var pid = first.pid;

        if(pid != 0) {
            if(!map[pid]) {
                data.push(first);
            }else{
                if(!map[pid].children) {
                    map[pid].children = [];
                }

                map[pid].children.push(first);
            }
        }
    }

    for(var i in map) {
        if(map[i].pid == 0) {
            d.push(map[i]);
        }
    }

    return d;
}

function closepage(data) {
    Frame.closeDialog(data);
}

function savepage() {
    Frame.submitForm({
        form: mainform,
        url: baseaction + "/save",
        success: function (result) {
            closepage(result);
        }
    });
}
