var maintree = $('#maintree');
var maingrid = $('#maingrid');
var baseaction = "sys/baseuser";
$(function () {
    initTree();
    initGrid();
});

function initTree() {
    maintree.tree({
        url: "sys/baseorg/tree",
        parentField: "pid",
        onSelect: function (node) {
            if (node.id) {
                doSearch();
            }
        },
        onLoadSuccess: function (node, data) {
            if(data.length>0){
                maintree.tree("collapseAll");
                var node = maintree.tree('find', data[0].id);
                maintree.tree('select', node.target);
            }
        }
    });
}

function initGrid() {
    maingrid.datagrid({
        singleSelect: true,
        rownumbers: true,
        fit: true,
        fitColumns: true,
        pagination: true,
        toolbar:".panel-toolbar",
        url: baseaction + "/page",
        columns: [[
            {field: 'userId', title: 'id', checkbox: true},
            {field: 'orgId', hidden: true},
            {field: 'deptId', hidden: true},
            {field: 'orgName', title: '组织机构', width: 80},
            {field: 'deptName', title: '部门', width: 80},
            {field: 'userName', title: '姓名', width: 80},
            {field: 'sex_TEXT', title: '性别', width: 80},
            {field: 'loginCode', title: '用户名', width: 80},
            {field: 'email', title: '邮箱', width: 80},
            {field: 'mobliephone', title: '手机号', width: 80},
            {field: 'accountState_TEXT', title: '用户状态', width: 60}
        ]]
    });
}

function reloadGrid() {
    maingrid.datagrid('reload');
}

function doSearch() {
    maingrid.datagrid('load', {
        searchText: $("#searchbox").val(),
        orgId: maintree.tree('getSelected').id
    });
}

//增加数据
function add() {
    var selectnode = Frame.singleSelect(maintree, "请先选择组织机构");
    if (selectnode) {
        Frame.openDialog({
            title:"用户新增",
            url: "view/sys/baseuser_form.html",
            params: {
                orgId: selectnode.id
            },
            onClose: reloadGrid
        });
    }

}

//修改数据
function edit() {
    var row = Frame.singleSelect(maingrid);
    if (row) {
        Frame.openDialog({
            url: "view/sys/baseuser_form.html",
            params: {
                id: row.userId
            },
            onClose: reloadGrid
        });
    }
}

//删除数据
function del() {
    var row = Frame.singleSelect(maingrid);
    if (row) {
        Frame.confirm({
            msg: "确定删除该条数据么?",
            handler: function (ok) {
                if (ok) {
                    Frame.ajax({
                        url: baseaction + "/logicDelete",
                        data: {
                            id: row.userId
                        },
                        success: function () {
                            reloadGrid();
                        }
                    });
                }
            }
        });
    }
}

//重置密码
function resetPassword() {
    var row = Frame.singleSelect(maingrid);
    if (row) {
        Frame.confirm({
            msg: "确定将该用户的密码重置为初始密码?",
            handler: function (ok) {
                if (ok) {
                    Frame.ajax({
                        url: baseaction + "/resetPassword",
                        data: {
                            id: row.userId
                        },
                        success: function () {
                        }
                    });
                }
            }
        });
    }
}


