var roleuserOut = $("#roleuserOut");
var baseaction = "sys/permission";
$(function () {

    var params = Frame.getDialogParams();

    roleuserOut.datagrid({
        border: false,
        rownumbers: true,
        fit: true,
        fitColumns: true,
        pagination: true,
        toolbar: "#roleuserOutToolbar",
        url: baseaction + "/userNotInRoleAndOrg",
        queryParams: {
            orgId: params.orgId,
            roleId: params.roleId
        },
        columns: [[
            {field: 'userId', checkbox: true},
            {field: 'userName', title: '姓名', width: 80},
            {field: 'loginCode', title: '用户名', width: 80},
            {field: 'deptName', title: '部门名称', width: 80}
        ]]
    });
});

function searchOut(value) {
    var params = Frame.getDialogParams();
    roleuserOut.datagrid('load', {
        orgId: params.orgId,
        roleId: params.roleId,
        searchText: value
    });
}

function closepage(data) {
    Frame.closeDialog(data);
}

function savepage() {
    var rows = roleuserOut.datagrid('getChecked');
    if (rows.length < 1) {
        Frame.info("请选择人员");
        return;
    }
    var userids = new Array();
    for (var i = 0; i < rows.length; i++) {
        userids.push(rows[i].userId);
    }

    closepage(userids);
}
