var orgtree = $('#orgtree');
var roletree = $('#roletree');
var roletreemenu = $("#roletreemenu");
var rolePermissionTree = $('#rolePermissionTree');
var adminPermissionTree = $('#adminPermissionTree');
var roleuserIn = $("#roleuserIn");
var roletabs = $("#tabs")
var baseaction = "sys/permission";
$(function () {
    $("#leftpanel").bind('contextmenu', function (e) {
        e.preventDefault();
        roletreemenu.empty();
        if(Frame.hasPermission("BASE_USER_ROLE.addRole")){
            roletreemenu.menu('appendItem', {
                text: '添加',
                onclick: addRole
            });
        }
        roletreemenu.menu('show', {
            left: e.pageX,
            top: e.pageY
        });
    });
    initTree();
    initGrid();
});

function initTree() {

    orgtree.combotree({
        url: baseaction+"/userOrgTree",
        parentField: "pid",
        onLoadSuccess: function (node, data) {
            if(data.length>0){
                orgtree.combotree('tree').tree("collapseAll");
                orgtree.combotree('setValue', data[0].id);
            }
        },
        onChange: function (newvalue, oldvalue) {
            roletree.tree({
                url: baseaction + "/roletree",
                queryParams: {
                    orgId: newvalue
                }
            });
        }
    });


    roletree.tree({
        url: baseaction + "/roletree",
        onContextMenu: function (e, node) {
            e.preventDefault();
            $(this).tree('select', node.target);
            roletreemenu.empty();
            if (currentRoleType != "COMMON_ROLE"||node.roleType==2) {
                if(Frame.hasPermission("BASE_USER_ROLE.editRole")) {
                    roletreemenu.menu('appendItem', {
                        text: '修改',
                        onclick: editRole
                    });
                }
            }
            if (currentRoleType != "COMMON_ROLE") {
                if(Frame.hasPermission("BASE_USER_ROLE.removeRole")) {
                    roletreemenu.menu('appendItem', {
                        text: '删除',
                        onclick: delRole
                    });
                }
            }
            roletreemenu.menu('show', {
                left: e.pageX,
                top: e.pageY
            });
        },
        onSelect: function (node) {
            loadRoleUserGrid();
            loadRolePermission();
            //只能给普通管理员分配权限
            loadAdminPermission(node.roleType);

        },
        onLoadSuccess: function () {
            roletree.tree("collapseAll");
        },
        formatter: function (node) {
            //超级管理员
            if (node.roleType == 0) {
                return "<span class=\"label label-dot label-danger\"></span>&nbsp;&nbsp;" + node.text;
                //普通管理员
            } else if (node.roleType == 1) {
                return "<span class=\"label label-dot label-info\" ></span>&nbsp;&nbsp;" + node.text;
            } else {
                return "<span class=\"label label-dot \" ></span>&nbsp;&nbsp;" + node.text;
                ;
            }
        }
    });

    rolePermissionTree.tree({
        checkbox: true,
        lines: true,
        url: baseaction + "/userPermissionTree",
        onLoadSuccess: function () {
            rolePermissionTree.tree("collapseAll");
        },
        formatter:permissionFormatter
    });

    adminPermissionTree.tree({
        checkbox: true,
        lines: true,
        url: baseaction + "/userPermissionTree",
        onLoadSuccess: function () {
            adminPermissionTree.tree("collapseAll");
        },
        formatter:permissionFormatter
    });

}

function permissionFormatter(node){
    if (node.nodeType =="menu") {
        return "<i class='icon icon-th-large text-blue'></i>&nbsp;"+node.text ;
        //普通管理员
    } if (node.nodeType =="btn") {
        return "<i class='icon icon-dot-circle text-green'></i>&nbsp;"+node.text;
    } if(node.nodeType == "perm") {
        return "<i class='icon icon-lock text-muted'></i>&nbsp;"+(node.text ? node.text : "--未添加[<span style='color:red;'>"+ node.permissionCode +"</span>]权限声明--");
    }else {
        return node.text;
    }
}

function initGrid() {
    roleuserIn.datagrid({
        border: false,
        rownumbers: true,
        fit: true,
        fitColumns: true,
        pagination: true,
        toolbar: "#roleuserInToolbar",
        url: baseaction + "/userInRoleAndOrg",
        columns: [[
            {field: 'userId', checkbox: true},
            {field: 'userName', title: '姓名', width: 80},
            {field: 'loginCode', title: '用户名', width: 80},
            {field: 'deptName', title: '部门名称', width: 80}
        ]]
    });
}

function loadRoleUserGrid() {
    roleuserIn.datagrid('load', {
        orgId: orgtree.combotree('getValue'),
        roleId: roletree.tree('getSelected').id
    });
}

function loadRolePermission() {
    Frame.ajax({
        url: baseaction + "/rolePermission",
        data: {
            roleId: roletree.tree('getSelected').id,
        },
        success: function (data) {
            rolePermissionTree.tree('uncheckAll');//全部取消选中
            var treedata=rolePermissionTree.data("tree").data;
            for (var j = 0; j < data.length; j++) {
                $.easyui.forEach(treedata,true,function(nodedata){
                    if(nodedata["permissionCode"]==data[j]){
                        if (rolePermissionTree.tree('isLeaf', nodedata.target)) {//只选中根节点
                            rolePermissionTree.tree('check', nodedata.target);//将得到的节点选中
                        }
                    }
                });
            }
        }
    })
}

function loadAdminPermission(roletype) {
    if (roletabs.tabs("exists", 2)) {
        //普通管理员
        if (roletype != 1) {
            roletabs.tabs("disableTab", 2);
            $("#saveAdminRoleMenu").addClass("disabled");
            $("#saveAdminRoleMenu").attr('disabled',"true");
            adminPermissionTree.tree('uncheckAll');//全部取消选中
        } else {
            roletabs.tabs("enableTab", 2);
            $("#saveAdminRoleMenu").removeClass("disabled");
            $("#saveAdminRoleMenu").removeAttr("disabled");
            Frame.ajax({
                url: baseaction + "/adminPermission",
                data: {
                    roleId: roletree.tree('getSelected').id,
                },
                success: function (data) {
                    adminPermissionTree.tree('uncheckAll');//全部取消选中
                    var treedata=adminPermissionTree.data("tree").data;
                    for (var j = 0; j < data.length; j++) {
                        $.easyui.forEach(treedata,true,function(nodedata){
                            if(nodedata["permissionCode"]==data[j]){
                                if (adminPermissionTree.tree('isLeaf', nodedata.target)) {//只选中根节点
                                    adminPermissionTree.tree('check', nodedata.target);//将得到的节点选中
                                }
                            }
                        });
                    }
                }
            })
        }
    }
}


function addRole() {
    var orgid=orgtree.combotree('getValue');
    if(orgid){
        Frame.openDialog({
            title:"添加角色",
            url: "view/sys/baserole_form.html",
            width:"500px",
            height:"300px",
            params: {
                orgId: orgid
            },
            onClose: function (result) {
                if(result){
                    refreshRole();
                }
            }
        });
    }else{
        Frame.info("没有选择组织机构");
    }

}

function editRole() {
    var selectnode = roletree.tree('getSelected');
    Frame.openDialog({
        title:"修改角色",
        url: "view/sys/baserole_form.html",
        width:"500px",
        height:"300px",
        params: {
            id: selectnode.id
        },
        onClose: function (result) {
            if(result){
                refreshRole();
            }
        }
    });
}

function delRole() {
    var selectnode = roletree.tree('getSelected');
    Frame.confirm({
        msg: "确定删除该角色么?",
        handler: function (ok) {
            if (ok) {
                Frame.ajax({
                    url: baseaction + "/deleteRole",
                    data: {
                        id: selectnode.id
                    },
                    showloading: true,
                    success: function () {
                        roletree.tree('remove', selectnode.target);
                    }
                });
            }
        }
    });
}

function refreshRole() {
    roletree.tree("reload");
}

function addRoleUser() {
    var selectnode = roletree.tree('getSelected');
    if (selectnode == null) {
        Frame.info("请先选择角色");
        return;
    }
    Frame.openDialog({
        title: "人员选择",
        url: "view/sys/baseroleuser_form.html",
        width: "400px",
        params: {
            orgId: orgtree.combotree('getValue'),
            roleId: roletree.tree('getSelected').id
        },
        onClose: function (result) {
            if (result) {
                Frame.ajax({
                    url: baseaction + "/checkin",
                    shade: true,
                    data: {
                        roleId: selectnode.id,
                        userids: result.join(",")
                    },
                    success: function () {
                        roleuserIn.datagrid('reload');
                    }
                })
            }
        }
    })
}

function removeRoleUser() {
    var selectnode = roletree.tree('getSelected');
    if (selectnode == null) {
        Frame.info("请先选择角色");
    }

    var rows = roleuserIn.datagrid('getChecked');
    if (rows.length < 1) {
        Frame.info("请选择人员");
        return;
    }
    var userids = new Array();
    for (var i = 0; i < rows.length; i++) {
        userids.push(rows[i].userId);
    }
    Frame.ajax({
        url: baseaction + "/checkout",
        shade: true,
        data: {
            roleId: selectnode.id,
            userids: userids.join(",")
        },
        success: function () {
            for (var i = 0; i < rows.length; i++) {
                roleuserIn.datagrid('deleteRow', roleuserIn.datagrid('getRowIndex', rows[i]));
            }
        }
    })
}

function searchIn(value) {
    roleuserIn.datagrid('load', {
        orgId: orgtree.combotree('getValue'),
        roleId: roletree.tree('getSelected').id,
        searchText: value
    });
}

function saveRolePermission() {
    if (!roletree.tree('getSelected')) {
        Frame.info("请先选择角色");
        return;
    }
    var allnodes = rolePermissionTree.tree('getChecked', ['unchecked', 'checked', 'indeterminate']);
    var nodes = rolePermissionTree.tree('getChecked', ['checked', 'indeterminate']);
    var menuids = new Array();
    var allmenuid = new Array();
    for (var i = 0; i < nodes.length; i++) {
        //if(roleMenuTree.tree('isLeaf',nodes[i].target)){//只保存根节点
        menuids.push(nodes[i].permissionCode);
        //}
    }
    for (var j = 0; j < allnodes.length; j++) {
        allmenuid.push(allnodes[j].permissionCode);
    }
    Frame.ajax({
        shade: true,
        url: baseaction + "/saveRolePermission",
        data: {
            roleId: roletree.tree('getSelected').id,
            checkedCodes: menuids.join(","),
            allCodes: allmenuid.join(",")
        }
    })
}

function saveAdminPermission() {
    if (!roletree.tree('getSelected')) {
        Frame.info("请先选择角色");
        return;
    }
    var allnodes = adminPermissionTree.tree('getChecked', ['unchecked', 'checked', 'indeterminate']);
    var nodes = adminPermissionTree.tree('getChecked', ['checked', 'indeterminate']);
    var menuids = new Array();
    var allmenuid = new Array();
    for (var i = 0; i < nodes.length; i++) {
        menuids.push(nodes[i].permissionCode);
    }

    for (var j = 0; j < allnodes.length; j++) {
        allmenuid.push(allnodes[j].permissionCode);
    }
    Frame.ajax({
        shade: true,
        url: baseaction + "/saveAdminPermission",
        data: {
            roleId: roletree.tree('getSelected').id,
            checkedCodes: menuids.join(","),
            allCodes: allmenuid.join(",")
        }
    })
}



