var maintree = $('#maintree');
var mainform = $('#mainform');
var treemenu = $("#treemenu");
$(function () {
    $("#orgtreepanel").bind('contextmenu', function (e) {
        e.preventDefault();
        treemenu.empty();
        treemenu.menu('appendItem', {
            text: '添加根节点',
            onclick: addroot
        });
        treemenu.menu('appendItem', {
            text: '刷新',
            onclick: refresh
        });
        treemenu.menu('show', {
            left: e.pageX,
            top: e.pageY
        });
    });
    initTree();

});

function initTree() {
    maintree.tree({
        url: "sys/baseorg/tree",
        parentField: "pid",
        onContextMenu: function (e, node) {
            e.preventDefault();
            $(this).tree('select', node.target);
            treemenu.empty();
            treemenu.menu('appendItem', {
                text: '添加',
                onclick: add
            });
            treemenu.menu('appendItem', {
                text: '删除',
                onclick: del
            });
            treemenu.menu('show', {
                left: e.pageX,
                top: e.pageY
            });
        },
        onSelect: function (node) {
            if (node.id) {
                Frame.loadForm(mainform,"sys/baseorg/findone?id=" + node.id);
            }
        },
        onLoadSuccess: function () {
            maintree.tree("collapseAll");
        }
    })
}

function addroot() {
    Frame.loadForm(mainform,{orgPid: 0});
}

function add() {
    var selectnode = maintree.tree('getSelected');
    if(selectnode.id){
        Frame.loadForm(mainform, {orgPid: selectnode.id});
    }
}

function del() {

    var selectnode = maintree.tree('getSelected');
    if(selectnode){
        Frame.confirm({
            msg: "确定删除该节点么?将同时删除所有下级节点",
            handler: function (ok) {
                if (ok) {
                    Frame.ajax({
                        shade:true,
                        url: "sys/baseorg/logicDelete",
                        data: {
                            id: selectnode.id
                        },
                        success: function () {
                            maintree.tree('remove', selectnode.target);
                            Frame.clearForm(mainform);
                        }
                    });
                }
            }
        });
    }
}

function save() {
    Frame.submitForm({
        form: mainform,
        url: "sys/baseorg/save",
        beforeSubmit:function(data){
            $.each(data,function(i,value){
                if(value.name=="orgPid"){
                    if(!value.value){
                        value.value=0;
                    }
                }
            });
        },
        success:function (result) {
            var newnode=Frame.updateTreeNode(maintree,{
                id:result.data.orgId,
                pid:result.data.orgPid,
                text:result.data.orgName
            });
            if(newnode){
                maintree.tree('select', newnode.target);
            }
        }
    });
}

function reset() {
    Frame.resetForm(mainform);
}

function refresh() {
    maintree.tree("reload");
    Frame.resetForm(mainform);

}