var orgtree = $('#orgtree');
var maintree = $('#maintree');
var mainform = $('#mainform');
var treemenu = $("#treemenu");
$(function () {
    $("#depttreepanel").bind('contextmenu', function (e) {
        e.preventDefault();
        treemenu.empty();
        treemenu.menu('appendItem', {
            text: '添加根节点',
            onclick: addroot
        });
        treemenu.menu('appendItem', {
            text: '刷新',
            onclick: refresh
        });
        treemenu.menu('show', {
            left: e.pageX,
            top: e.pageY
        });
    });
    initTree();
});

function initTree() {

    orgtree.combotree({
        url: "sys/baseorg/tree",
        parentField: "pid",
        onLoadSuccess: function (node, data) {
            if(data.length>0){
                orgtree.combotree('tree').tree("collapseAll");
                orgtree.combotree('setValue', data[0].id);
            }
        },
        onChange: function (newvalue, oldvalue) {
            maintree.tree({
                url: "sys/basedept/tree",
                queryParams: {
                    orgId: newvalue
                }
            });
            mainform.form('clear');
        }
    });


    maintree.tree({
        url: "sys/basedept/tree",
        parentField: "pid",
        onContextMenu: function (e, node) {
            e.preventDefault();
            $(this).tree('select', node.target);
            treemenu.empty();
            treemenu.menu('appendItem', {
                text: '添加',
                onclick: add
            });
            treemenu.menu('appendItem', {
                text: '删除',
                onclick: del
            });
            treemenu.menu('show', {
                left: e.pageX,
                top: e.pageY
            });
        },
        onSelect: function (node) {
            if (node.id) {
                Frame.loadForm(mainform, "sys/basedept/findone?id=" + node.id);
            }
        },
        onLoadSuccess: function () {
            maintree.tree("collapseAll");
        }
    })
}

function addroot() {
    var orgid=orgtree.combotree('getValue');
    if(orgid){
        mainform.form('clear');
        mainform.form('load', {
            deptPid: 0,
            orgId: orgid
        });
    }else{
        Frame.info("没有选择组织机构");
    }

}

function add() {
    var orgid=orgtree.combotree('getValue');
    if(orgid){
        var selectnode = maintree.tree('getSelected');
        mainform.form('clear');
        mainform.form('load', {
            deptPid: selectnode.id,
            orgId: orgid
        });
    }else{
        Frame.info("没有选择组织机构");
    }

}

function del() {
    var selectnode = maintree.tree('getSelected');
    if (selectnode) {
        Frame.confirm({
            msg: "确定删除该节点么?将同时删除所有下级节点",
            handler: function (ok) {
                if (ok) {
                    Frame.ajax({
                        shade: true,
                        url: "sys/basedept/logicDelete",
                        data: {
                            id: selectnode.id
                        },
                        success: function () {
                            maintree.tree('remove', selectnode.target);
                            mainform.form('clear');
                        }
                    });
                }
            }
        });
    }

}

function save() {
    var orgid=orgtree.combotree('getValue');
    if(orgid){
        Frame.submitForm({
            form: mainform,
            url: "sys/basedept/save",
            beforeSubmit:function(data){
                $.each(data,function(i,value){
                    if(value.name=="deptPid"){
                        if(!value.value){
                            value.value=0;
                        }
                    }
                    if(value.name=="orgId"){
                        if(!value.value){
                            value.value=orgid;
                        }
                    }
                });
            },
            success: function (result) {
                var resultdata = result.data;
                Frame.updateTreeNode(maintree, {
                    id: resultdata.deptId,
                    pid: resultdata.deptPid,
                    text: resultdata.deptName
                });
            }
        });
    }else{
        Frame.info("没有选择组织机构");
    }


}

function reset() {
    mainform.form('reset');
}

function refresh() {
    maintree.tree("reload");
    mainform.form('reset');

}