package com.kdgcsoft.scrdc.frame.webframe.sys.service;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.crypto.SecureUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.scrdc.frame.webframe.base.service.BaseDicService;
import com.kdgcsoft.scrdc.frame.webframe.base.util.DicConverter;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.CoreInitParams;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPage;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;
import com.kdgcsoft.scrdc.frame.webframe.core.service.BaseService;
import com.kdgcsoft.scrdc.frame.webframe.sys.dao.BaseUserDao;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:27
 * @version: 1.0
 **/
@Service
public class BaseUserService extends BaseService {
    @Autowired
    private BaseUserDao baseUserDao;

    @Autowired
    private BaseDicService baseDicService;

    @Autowired
    private BaseOrgService baseOrgService;

    public GridPage page(IPage<?> pageable, Long orgId, String searchText) {
       List<Long> orgIds=baseOrgService.getOrgIdstartWith(orgId);
        IPage<Map> page = baseUserDao.page(pageable,orgIds, searchText);
        new DicConverter(page.getRecords())
                .add("sex",baseDicService.listByCode("SEX"))
                .add("accountState",baseDicService.listByCode("ACCOUNT_STATE"))
                .convert();
        return GridPage.of(page);
    }

    public List<BaseUser> findByLoginCode(String loginCode) {
        return baseUserDao.findByLoginCode(loginCode);
    }

    public BaseUser findOne(Long id) {
        return baseUserDao.selectById(id);
    }

    public JsonResult checkRepeat(BaseUser entity) {
        JsonResult msg = JsonResult.success();
        Long count = baseUserDao.checkrepeat(entity.getUserId(),entity.getLoginCode());
        if (count > 0) {
            msg.setSuccess(false);
            msg.setMsg("用户账号不能重复");
            return msg;
        } else {
            return msg;
        }
    }

    public BaseUser save(BaseUser entity) {
        if (entity.getUserId() == null) {
            entity.setLoginPassword(SecureUtil.md5(frameService.getParamStr(CoreInitParams.USER_DEF_PASSWORD)));
            baseUserDao.insert(entity);
        }else{
            // 为啥要用旧密码？
//            BaseUser olduser=baseUserDao.selectById(entity.getUserId());
//            entity.setLoginPassword(olduser.getLoginPassword());
			baseUserDao.updateById(entity);
        }
        return entity;
    }

    public void logicDelete(Long id) {
        baseUserDao.logicDelete(id);
    }

    public void resetPassword(Long id) {
        BaseUser entity = findOne(id);
        if(entity!=null){
            entity.setLoginPassword(SecureUtil.md5(frameService.getParamStr(CoreInitParams.USER_DEF_PASSWORD)));
            baseUserDao.updateById(entity);
        }
    }


    /*public List<Map> chooseTaskUser(Long roleId, Long themeId, Long[] exclusionids, String searchText) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("exclusionids", exclusionids);
        params.put("roleId", roleId);
        params.put("themeId", themeId);
        params.put("searchText", searchText);
        return sqlmanager.select("baseUser.chooseTaskUser", Map.class, params);
    }*/

    public Object updateUserInfo(BaseUser entity) {
        baseUserDao.updateById(entity);
        return entity;
    }

    public JsonResult changePassword(Long userId,String oldPassword,String newPassword) {
        BaseUser user=findOne(userId);
        if(user==null){
            return JsonResult.error("用户不存在");
        }else{
            String oldP = Base64Decoder.decodeStr(oldPassword);
            String userPassword = SecureUtil.sha256(user.getLoginPassword());
            if(!oldP.equals(userPassword)){
                return JsonResult.error("原密码不正确");
            }else{
                user.setLoginPassword(Base64Decoder.decodeStr(newPassword));
                save(user);
                return JsonResult.success("密码修改成功,请使用新密码重新登录");
            }
        }
    }

    /*public Object updateUser(BaseUser entity) {
        JsonResult msg =JsonResult.success();
        String np1 = entity.getNewPassword();
        String np2 = entity.getNewsPassword();
        if (!np1.equals(np2)) {
            msg.setMsg("二次输入的密码不一致！");
            msg.setSuccess(false);
            return msg;
        }
        entity.setAccountPassword(SecureUtil.md5(np1));
        baseUserDao.save(entity);
        msg.setSuccess(true);
        msg.setMsg("修改成功！");
        return msg;
    }*/
}
