package com.kdgcsoft.scrdc.frame.webframe.sys.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.LogicDelete;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BaseMenuBtnDao;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.BasePermissionDao;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseMenu;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseMenuBtn;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BasePermission;
import com.kdgcsoft.scrdc.frame.webframe.base.service.BaseMenuService;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.StateEnum;
import com.kdgcsoft.scrdc.frame.webframe.core.helper.TreeHelper;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPage;
import com.kdgcsoft.scrdc.frame.webframe.core.model.LoginUser;
import com.kdgcsoft.scrdc.frame.webframe.core.model.UiTreeNode;
import com.kdgcsoft.scrdc.frame.webframe.core.service.BaseService;
import com.kdgcsoft.scrdc.frame.webframe.sys.dao.BaseAdminPermissionDao;
import com.kdgcsoft.scrdc.frame.webframe.sys.dao.BaseRoleDao;
import com.kdgcsoft.scrdc.frame.webframe.sys.dao.BaseRolePermissionDao;
import com.kdgcsoft.scrdc.frame.webframe.sys.dao.BaseRoleUserDao;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseAdminPermission;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseRole;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseRolePermission;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseRoleUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:26
 * @version: 1.0
 **/
@Service
public class BasePermissionService extends BaseService {
    @Autowired
    private BaseRoleDao baseRoleDao;
    @Autowired
    private BaseRoleUserDao baseRoleUserDao;
    @Autowired
    private BaseRolePermissionDao baseRolePermissionDao;
    @Autowired
    private BaseAdminPermissionDao baseAdminPermissonDao;
    @Autowired
    private BaseMenuService baseMenuService;
    @Autowired
    private BaseMenuBtnDao baseMenuBtnDao;
    @Autowired
    private BasePermissionDao permissionDao;
    
    public List<Map> tree(Long orgId) {
        return baseRoleDao.tree(orgId);
    }
    
    public List<Map> treeByRoleType(Long orgId, List<Integer> roletypes) {
        return baseRoleDao.treeByRoleTypes(orgId, roletypes);
    }
    
    public boolean isSuperAdminInDb(Long userId) {
        List<BaseRole> roles = baseRoleDao.userRoles(userId);
        for (BaseRole role : roles) {
            if (role.getRoleType() == BaseRole.RoleType.SUPER_ADMIN) {
                return true;
            } else {
                continue;
            }
        }
        return false;
    }
    
    
    public BaseRole.RoleType userTopRoleType(LoginUser loginUser) {
        if (loginUser.isSuperAdmin()) {
            return BaseRole.RoleType.SUPER_ADMIN;
        }
        List<BaseRole> roles = baseRoleDao.userRoles(loginUser.getUserId());
        for (BaseRole role : roles) {
            if (role.getRoleType() == BaseRole.RoleType.SUPER_ADMIN) {
                return role.getRoleType();
            } else if (role.getRoleType() == BaseRole.RoleType.COMMON_ADMIN) {
                return role.getRoleType();
            }
        }
        return BaseRole.RoleType.COMMON_ROLE;
    }
    
    public BaseRole findOne(Long id) {
        BaseRole entity = baseRoleDao.selectById(id);
        return entity;
    }
    
    public BaseRole save(BaseRole entity) {
    	if(entity.getRoleId() == null){
    		baseRoleDao.insert(entity);
		}else {
			baseRoleDao.updateById(entity);
		}
        return entity;
    }
    
    @Transactional(rollbackFor = Exception.class)
    public void deleteRole(Long id) {
        baseRoleDao.deleteById(id);
        baseRolePermissionDao.deleteByRoleId(id);
        baseAdminPermissonDao.deleteByRoleId(id);
    }
    
    public List<UiTreeNode> userPermissionTree(LoginUser user) {
        /**权限管理模式是层级模式**/
        List<UiTreeNode> menutree = new ArrayList<>();
        if (StrUtil.equals(frameService.getParamStr("ROLE_MANAGE_MODE"), "2")) {
            if (user.isSuperAdmin()) {
                menutree = TreeHelper.buildFullMenuTree(baseMenuService.allMenus());
            } else {
                menutree = adminMenuTree(user);
            }
        } else {
            menutree = TreeHelper.buildFullMenuTree(baseMenuService.allMenus());
        }
        
        buildMenuPermissionCode(menutree);
        
        /**权限控制级别到按钮时 需要在菜单树上加入按钮**/
        int permLevel = Integer.parseInt(frameService.getParamStr("PERMISSION_LEVEL"));
        if (permLevel >= 2) {
            List<BaseMenuBtn> btnlist;
            if (user.isSuperAdmin()) {
                btnlist = baseMenuBtnDao.findByLogicDeleteAndBtnState(LogicDelete.N, StateEnum.Y);
            } else {
                btnlist = baseAdminPermissonDao.adminMenuBtns(user.getUserId());
            }
            buildMenuBtnsPermissionCode(menutree, btnlist);
        }
        
        if (permLevel == 3) {
            List<BasePermission> perms = permissionDao.selectList(null);
            List<BaseRole> roles =baseRoleDao.userRoles(user.getUserId());
            List<Long> roleIds = new ArrayList<>();
            
            if(CollectionUtil.isNotEmpty(roles)) {
                roles.forEach(r -> roleIds.add(r.getRoleId()));
            }
            
            List<BaseRolePermission> permissions = baseRolePermissionDao.findAllByRoleIdIn(roleIds);
            Set<String> permCodes = new HashSet<>();
            if(CollectionUtil.isNotEmpty(permissions)) {
                permissions.forEach(p -> permCodes.add(p.getPermissionCode()));
            }
            
            if (CollectionUtil.isNotEmpty(perms)) {
                Map<String, UiTreeNode> nodes = new HashMap<>();
        
                for (BasePermission perm : perms) {
                    UiTreeNode node = new UiTreeNode();
                    node.setId(perm.getPermId()
                                   .toString());
                    node.setText(perm.getPermName());
                    node.setPid(perm.getPermPid()
                                    .toString());
                    node.setChecked(permCodes.contains(perm.getPermCode()));
                    node.addAttributes("permissionCode", perm.getPermCode());
                    node.addAttributes("nodeType", "perm");
                    nodes.put(node.getId(), node);
                }
        
                nodes.forEach((k, v) -> {
                    String pid = v.getPid();
                    if (!pid.equals("0")) {
                        nodes.get(pid)
                             .addChild(v);
                    }
                });
        
                List<UiTreeNode> list = new ArrayList<>();
                for (UiTreeNode n : nodes.values()) {
                    if (n.getPid()
                         .equals("0")) {
                        list.add(n);
                    }
                }
                UiTreeNode permNode = new UiTreeNode();
                permNode.setId("0");
                permNode.setText("细粒度权限");
                permNode.setChildren(list);
                menutree.add(permNode);
            }
        }
        
        return menutree;
    }
    
    private void buildMenuPermissionCode(List<UiTreeNode> menutree) {
        if (CollUtil.isNotEmpty(menutree)) {
            for (UiTreeNode node : menutree) {
                node.addAttributes("permissionCode", node.getAttr("menuCode"));
                node.addAttributes("nodeType", "menu");
                buildMenuPermissionCode(node.getChildren());
            }
        }
    }
    
    private void buildMenuBtnsPermissionCode(List<UiTreeNode> menutree, List<BaseMenuBtn> btnlist) {
        if (CollUtil.isNotEmpty(menutree)) {
            for (UiTreeNode node : menutree) {
                /**没有子节点的菜单才会在下面加上按钮**/
                if (CollUtil.isEmpty(node.getChildren())) {
                    List<BaseMenuBtn> menuBtns = CollUtil.filter(btnlist, (Filter<BaseMenuBtn>) baseMenuBtn -> {
                        if (StrUtil.equals(StrUtil.utf8Str(node.getAttr("menuCode")), baseMenuBtn.getMenuCode())) {
                            return true;
                        } else {
                            return false;
                        }
                    });
                    /*如果菜单下面有按钮,则添加一个相同编码的浏览按钮**/
                    if (CollUtil.isNotEmpty(menuBtns)) {
                        UiTreeNode accessnode = new UiTreeNode();
                        accessnode.setId(node.getId() + "_btn");
                        accessnode.setText("访问");
                        accessnode.addAttributes("permissionCode", StrUtil.utf8Str(node.getAttr("permissionCode")));
                        accessnode.addAttributes("nodeType", "btn");
                        node.addChild(accessnode);
                    }
                    for (BaseMenuBtn btn : menuBtns) {
                        UiTreeNode btnnode = new UiTreeNode();
                        btnnode.setId(btn.getMenuBtnId()
                                         .toString());
                        btnnode.setText(btn.getBtnName());
                        btnnode.addAttributes("permissionCode", btn.getBtnCode());
                        btnnode.addAttributes("nodeType", "btn");
                        node.addChild(btnnode);
                    }
                } else {
                    buildMenuBtnsPermissionCode(node.getChildren(), btnlist);
                }
            }
        }
    }
    
    
    public GridPage userInRoleAndOrg(IPage<?> pageable, Long orgId, Long roleId, String searchText) {
    	if(StrUtil.isNotEmpty(searchText)){
    		searchText = "%" + searchText + "%";
		}
        IPage<Map> page = baseRoleUserDao.userInRoleAndOrg(pageable, roleId, orgId, searchText);
        return GridPage.of(page);
    }
    
    public GridPage userNotInRoleAndOrg(IPage<?> pageable, Long orgId, Long roleId, String searchText) {
		if(StrUtil.isNotEmpty(searchText)){
			searchText = "%" + searchText + "%";
		}
    	IPage<Map> page = baseRoleUserDao.userNotInRoleAndOrg(pageable, roleId, orgId, searchText);
        return GridPage.of(page);
    }
    
    public void checkin(Long roleId, Long[] userids) {
        for (Long userid : userids) {
            BaseRoleUser roleuser = new BaseRoleUser();
            roleuser.setRoleId(roleId);
            roleuser.setUserId(userid);
			baseRoleUserDao.insert(roleuser);
        }
    }
    
    @Transactional(rollbackFor = Exception.class)
    public void checkout(Long roleId, List<Long> userids) {
        baseRoleUserDao.checkout(roleId, userids);
    }
    
    public List<String> rolePermission(Long roleId) {
        return baseRolePermissionDao.findPermissionCodesByRoleId(roleId);
    }
    
    public List<String> adminPermission(Long roleId) {
        return baseAdminPermissonDao.findPermissionCodesByRoleId(roleId);
    }
    
    @Transactional(rollbackFor = Exception.class)
    public void saveRolePermission(Long roleId, String[] allCodes, String[] checkedCodes) {
        if (ArrayUtil.isNotEmpty(allCodes)) {
            baseRolePermissionDao.cleanPermissionByRoleAndCode(roleId, CollUtil.newArrayList(allCodes));
        }
        for (String permissonCode : checkedCodes) {
            if(permissonCode.isEmpty()) {
                continue;
            }
            
            BaseRolePermission rolemenu = new BaseRolePermission();
            rolemenu.setRoleId(roleId);
            rolemenu.setPermissionCode(permissonCode);
			baseRolePermissionDao.insert(rolemenu);
        }
    }
    
    @Transactional(rollbackFor = Exception.class)
    public void saveAdminPermission(Long roleId, String[] allCodes, String[] checkedCodes) {
        if (ArrayUtil.isNotEmpty(allCodes)) {
            baseAdminPermissonDao.cleanPermissionByRoleAndCode(roleId, CollUtil.newArrayList(allCodes));
        }
        for (String permissonCode : checkedCodes) {
            if(permissonCode.isEmpty()) {
                continue;
            }
            BaseAdminPermission rolemenu = new BaseAdminPermission();
            rolemenu.setRoleId(roleId);
            rolemenu.setPermissionCode(permissonCode);
			baseAdminPermissonDao.insert(rolemenu);
        }
    }
    
    public List<UiTreeNode> adminMenuTree(LoginUser loginUser) {
        return TreeHelper.buildUserMenuTree(baseMenuService.allMenus(), baseAdminPermissonDao.adminMenus(loginUser.getUserId()));
    }
    
    public List<String> userPermissions(Long userId) {
        return baseRolePermissionDao.userPermissions(userId);
    }
    
    public List<String> superAdminPermissions() {
        List<BaseMenu> menus = baseMenuService.allMenus();
        List<String> permissions = new ArrayList<>();
        
        if (CollectionUtil.isNotEmpty(menus)) {
            for (BaseMenu menu : menus) {
                permissions.add(menu.getMenuCode());
            }
        }
        
        List<BaseMenuBtn> btns = baseMenuBtnDao.selectList(null);
        
        if (CollectionUtil.isNotEmpty(btns)) {
            for (BaseMenuBtn btn : btns) {
                permissions.add(btn.getMenuCode());
                permissions.add(btn.getBtnCode());
            }
        }
    
        List<BasePermission> perms = permissionDao.selectList(null);
        
        if(CollectionUtil.isNotEmpty(perms)) {
            for (BasePermission perm : perms) {
                permissions.add(perm.getPermCode());
            }
        }
        
        return permissions;
    }
    
    public List<String> userRoles(Long userId) {
        return baseRoleUserDao.findRoleNameByUserId(userId);
    }
    
    public List<String> userAccessMenus(List<String> permissions) {
        if (CollectionUtil.isEmpty(permissions)) {
            return Collections.emptyList();
        }
        
        List<BaseMenu> menus = baseMenuService.findMenuIn(permissions);
        return Optional.ofNullable(menus)
                       .orElse(Collections.emptyList())
                       .stream()
                       .map(BaseMenu::getMenuUrl)
                       .collect(Collectors.toList());
    }
}
