package com.kdgcsoft.scrdc.frame.webframe.sys.service;

import com.kdgcsoft.scrdc.frame.webframe.core.service.BaseService;
import com.kdgcsoft.scrdc.frame.webframe.sys.dao.BaseOrgDao;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseOrg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/9/6/006 14:33
 * @version: 1.0
 **/
@Service
public class BaseOrgService extends BaseService {
    @Autowired
    private BaseOrgDao baseOrgDao;

    public BaseOrg findById(Long id) {
        return baseOrgDao.selectById(id);
    }
    @Cacheable(cacheNames = "ORG_CACHE", key = "#root.methodName")
    public List<Map> tree() {
        return baseOrgDao.tree();
    }

    @CacheEvict(cacheNames = "ORG_CACHE", allEntries = true)
    @Transactional(rollbackFor = Exception.class)
    public BaseOrg save(BaseOrg entity) {
    	if(entity.getOrgId() == null){
    		baseOrgDao.insert(entity);
		}else {
			baseOrgDao.updateById(entity);
		}
        return entity;
    }

    @CacheEvict(cacheNames = "ORG_CACHE", allEntries = true)
    @Transactional(rollbackFor = Exception.class)
    public void logicDelete(Long id) {
        baseOrgDao.logicDelete(id);
    }

    /**
     * 级联删除(逻辑)
     *
     * @param id
     */
    @CacheEvict(cacheNames = "ORG_CACHE", allEntries = true)
    @Transactional(rollbackFor = Exception.class)
    public void logicDeleteCascade(Long id) {
        BaseOrg entity = baseOrgDao.selectById(id);
        if(entity != null) {
            baseOrgDao.logicDelete(id);
            List<BaseOrg> childlist = baseOrgDao.findByOrgPid(entity.getOrgId());
            for (BaseOrg child : childlist) {
                logicDeleteCascade(child.getOrgId());
            }
        }
    }
    @Cacheable(cacheNames = "ORG_CACHE", key = "#root.methodName+'.'+#orgId")
    public  List<Long> getOrgIdstartWith(Long orgId){
        List<Long> ids=new ArrayList<>();
        if(orgId!=null){
            BaseOrg entity = baseOrgDao.selectById(orgId);
            if(entity != null) {
                ids.add(entity.getOrgId());
                List<BaseOrg> childlist = baseOrgDao.findByOrgPid(entity.getOrgId());
                for (BaseOrg child : childlist) {
                    ids.addAll(getOrgIdstartWith(child.getOrgId()));
                }
            }
        }
        return ids;
    }
}
