package com.kdgcsoft.scrdc.frame.webframe.sys.service;

import com.kdgcsoft.scrdc.frame.webframe.core.service.BaseService;
import com.kdgcsoft.scrdc.frame.webframe.sys.dao.BaseDeptDao;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseDept;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;


/**
 * @description:
 * @author: fyin
 * @date: 2018/9/6/006 16:29
 * @version: 1.0
 **/
@Service
public class BaseDeptService extends BaseService {
	@Autowired
	private BaseDeptDao baseDeptDao;
	
	public BaseDept findOne(Long id){
		return baseDeptDao.selectById(id);
	}
	
	public List<Map> tree(Long orgId){
		return baseDeptDao.tree(orgId);
	}

	@Transactional(rollbackFor = Exception.class)
	public BaseDept save(BaseDept entity){
		if(entity.getDeptId() == null){
			baseDeptDao.insert(entity);
		}else {
			baseDeptDao.updateById(entity);
		}
		return entity;
	}
	@Transactional(rollbackFor = Exception.class)
	public void logicDelete(Long id){
		baseDeptDao.logicDelete(id);
	}

	@Transactional(rollbackFor = Exception.class)
	public void logicDeleteCascade(Long id){
		BaseDept entity=findOne(id);
		if(entity!=null) {
			baseDeptDao.logicDelete(id);
			List<BaseDept> childlist= baseDeptDao.findByDeptPid(entity.getDeptId());
			for(BaseDept child:childlist) {
				logicDeleteCascade(child.getDeptId());
			}
		}
	}
}
