package com.kdgcsoft.scrdc.frame.webframe.sys.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.enums.IEnum;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.BaseEntity;
import lombok.Getter;
import lombok.Setter;

/**
 * @description:
 * @author: fyin
 * @date: 2018/9/3/003 15:32
 * @version: 1.0
 **/
@TableName
@Setter
@Getter
public class BaseRole extends BaseEntity {
    @TableId
    private Long roleId;

    private Long orgId;
    private String roleName;
    private RoleType roleType;

    public enum RoleType implements IEnum<Integer> {
        /**超级管理员*/
        SUPER_ADMIN(0),
        /**普通管理员**/
        COMMON_ADMIN(1),
        /**普通角色**/
        COMMON_ROLE(2);

        private int index;
		RoleType(int i) {
			this.index = i;
		}

		@Override
		public Integer getValue() {
			return this.index;
		}
	}
}
