package com.kdgcsoft.scrdc.frame.webframe.sys.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseUser;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:26
 * @version: 1.0
 **/
public interface BaseUserDao extends BaseMapper<BaseUser> {
    

    IPage<Map> page(IPage<?> pageable, @Param("orgIds") List<Long> orgIds, @Param("searchText") String searchText);

    @Select("select * from base_user t where t.logic_delete=0 and t.account_state=1 and t.login_code=#{loginCode}       \n")
    List<BaseUser> findByLoginCode(@Param("loginCode") String loginCode);

    Long checkrepeat(@Param("userId") Long userId, @Param("loginCode") String loginCode);

    @Select("SELECT * FROM BASE_USER WHERE ORG_ID = #{orgId} AND DEPT_ID = #{deptId}")
    List<BaseUser> findByOrgIdAndDeptId(@Param("orgId")Long orgId, @Param("deptId")Long deptId);

	@Select("SELECT * FROM BASE_USER WHERE ORG_ID = #{orgId}")
	List<BaseUser> findByOrgId(@Param("orgId")Long orgId);

	@Select("SELECT * FROM BASE_USER WHERE DEPT_ID = #{deptId}")
	List<BaseUser> findByDeptId(@Param("deptId")Long deptId);

    @Update("UPDATE BASE_USER SET LOGIC_DELETE = 1 WHERE USER_ID = #{id}")
	void logicDelete(@Param("id")Long id);
}
