package com.kdgcsoft.scrdc.frame.webframe.sys.dao;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseRoleUser;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:26
 * @version: 1.0
 **/
public interface BaseRoleUserDao extends BaseMapper<BaseRoleUser> {

    int checkout(@Param("roleId") Long roleId, @Param("userids") List<Long> userids);

    IPage<Map> userInRoleAndOrg(IPage<?> pageable, @Param("roleId") Long roleId, @Param("orgId") Long orgId, @Param("searchText")  String searchText);

    IPage<Map> userNotInRoleAndOrg(IPage<?> pageable, @Param("roleId") Long roleId, @Param("orgId") Long orgId, @Param("searchText")  String searchText);

    @Select("SELECT * FROM BASE_ROLE_USER WHERE ROLE_ID = #{roleId}")
    List<BaseRoleUser> findByRoleId(@Param("roleId")Long roleId);
    
	@Select("SELECT r.role_name from base_role r\n" +
			"left join base_role_user ru \n" +
			"on r.role_id = ru.role_id\n" +
			"where ru.user_id = #{userId}   ")
    List<String> findRoleNameByUserId(@Param("userId") Long userId);
}
