package com.kdgcsoft.scrdc.frame.webframe.sys.dao;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseRolePermission;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:25
 * @version: 1.0
 **/
public interface BaseRolePermissionDao extends BaseMapper<BaseRolePermission> {
    /**
     * 清除角色指定的授权
     * @param roleId 角色ID
     * @param allCodes 权限编码列表
     */

    void cleanPermissionByRoleAndCode(@Param("roleId") Long roleId,@Param("allCodes") List<String> allCodes);

    /**
     * 根据角色ID清除所有的权限
     * @param roleId
     */
    @Delete("DELETE FROM BASE_ROLE_PERMISSION WHERE ROLE_ID = #{roleId}")
    void deleteByRoleId(@Param("roleId")Long roleId);

    /**
     * 查找指定角色的所有权限编码
     * @param roleid
     * @return
     */
	@Select("select distinct t.permission_code from base_role_permission t where  t.role_id=#{roleId} AND t.logic_delete = 0")
    List<String> findPermissionCodesByRoleId(@Param("roleId") Long roleid);

    /**
     * 查找用户的权限编码列表
     * @param userId
     * @return
     */
	@Select("SELECT distinct a.permission_code" +
			"            FROM base_role_permission a" +
			"            WHERE a.role_id IN (SELECT b.role_id" +
			"            FROM base_role_user b left join base_role r" +
			"            on b.role_id=r.role_id " +
			"            WHERE b.user_id = #{userId} and r.logic_delete = 0 )")
    List<String> userPermissions(@Param("userId") Long userId);

    List<BaseRolePermission> findAllByRoleIdIn(@Param("roleIds")List<Long> roleIds);
}
