package com.kdgcsoft.scrdc.frame.webframe.sys.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseRole;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:25
 * @version: 1.0
 **/
public interface BaseRoleDao extends BaseMapper<BaseRole> {

	@Select("select t.role_id as id,t.role_name as text,t.role_type from base_role t " +
			"where t.logic_delete=0 and t.org_id=#{orgId} order by t.role_id")
	List<Map> tree(@Param("orgId") Long orgId);

	List<Map> treeByRoleTypes(@Param("orgId") Long orgId ,@Param("roleTypes")List<Integer> roleTypes);

	@Select("select * from base_role t \n" +
			"where t.logic_delete=0 and t.role_id in (select a.role_id  from base_role_user a where a.user_id=#{userId} and a.logic_delete=0 ) order by t.role_name\n")
	List<BaseRole> userRoles(@Param("userId")Long userId);
}
