package com.kdgcsoft.scrdc.frame.webframe.sys.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseOrg;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:25
 * @version: 1.0
 **/
public interface BaseOrgDao extends BaseMapper<BaseOrg> {

	@Select("select t.org_id as id,t.org_pid as pid,t.org_name as text from base_org t\n" +
			"            where t.logic_delete=0 order by t.order_no")
    List<Map> tree();

	@Select("SELECT * FROM BASE_ORG WHERE ORG_PID = #{orgPid}")
    List<BaseOrg> findByOrgPid(@Param("orgPid") Long orgPid);

    @Update("UPDATE BASE_ORG SET LOGIC_DELETE = 1 WHERE ORG_ID = #{id}")
	void logicDelete(@Param("id")Long id);
}
