package com.kdgcsoft.scrdc.frame.webframe.sys.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseDept;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:24
 * @version: 1.0
 **/
public interface BaseDeptDao extends BaseMapper<BaseDept> {

	@Select("select t.dept_id as id,t.dept_pid as pid,t.dept_name as text\n" +
			"            from base_dept t\n" +
			"            where t.logic_delete=0 and t.org_id=#{orgId} order by t.order_no\n")
    List<Map> tree(@Param("orgId") Long orgId);

	@Select("SELECT * FROM BASE_DEPT WHERE DEPT_PID = #{deptPid}")
    List<BaseDept> findByDeptPid(@Param("deptPid")Long deptPid);

    @Update("UPDATE BASE_DEPT SET LOGIC_DELETE = 1 WHERE DEPT_ID = #{id}")
	void logicDelete(@Param("id")Long id);
}
