package com.kdgcsoft.scrdc.frame.webframe.sys.dao;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseMenu;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.BaseMenuBtn;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseAdminPermission;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:25
 * @version: 1.0
 **/
public interface BaseAdminPermissionDao extends BaseMapper<BaseAdminPermission> {

    void cleanPermissionByRoleAndCode(@Param("roleId") Long roleId, @Param("allCodes") List<String> allCodes);

    @Delete("DELETE FROM BASE_ADMIN_PERMISSION WHERE ROLE_ID = #{roleId}")
    void deleteByRoleId(@Param("roleId")Long roleId);


    @Select("select distinct t.permission_code from base_admin_permission t where  t.role_id=#{roleId} AND t.logic_delete = 0")
    List<String> findPermissionCodesByRoleId(@Param("roleId") Long roleid);

    /**
     * 获取当前登陆人员作为普通管理员所拥有的权限列表
     **/
	@Select("SELECT t.*\n" +
			"            FROM base_menu t\n" +
			"            WHERE t.menu_code IN (SELECT a.permission_code\n" +
			"            FROM base_admin_permission a\n" +
			"            WHERE a.role_id IN (SELECT b.role_id\n" +
			"            FROM base_role_user b left join base_role r\n" +
			"            on b.role_id=r.role_id \n" +
			"            WHERE b.user_id = #{userId} and r.role_type=1))\n" +
			"            AND t.logic_delete = 0\n" +
			"            AND t.menu_state = 1\n" +
			"            ORDER BY t.order_no")
    List<BaseMenu> adminMenus(@Param("userId") Long userId);

	@Select("SELECT t.*\n" +
			"            FROM base_menu_btn t\n" +
			"            WHERE t.btn_code IN (SELECT a.permission_code\n" +
			"            FROM base_admin_permission a\n" +
			"            WHERE a.role_id IN (SELECT b.role_id\n" +
			"            FROM base_role_user b left join base_role r\n" +
			"            on b.role_id=r.role_id \n" +
			"            WHERE b.user_id = #{userId} and r.role_type=1))\n" +
			"            AND t.logic_delete = 0\n" +
			"            AND t.btn_state = 1\n" +
			"            ORDER BY t.menu_btn_id")
    List<BaseMenuBtn> adminMenuBtns(@Param("userId") Long userId);
    

}
