package com.kdgcsoft.scrdc.frame.webframe.sys.controller;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.controller.BaseController;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.CoreInitParams;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPage;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPageRequest;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;
import com.kdgcsoft.scrdc.frame.webframe.core.model.LoginUser;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseUser;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:26
 * @version: 1.0
 **/
@Controller
@RequestMapping("/sys/baseuser")
public class BaseUserController extends BaseController {
    @Autowired
    private BaseUserService baseUserService;

    @RequestMapping("/index")
    public ModelAndView index() {
        return renderView("/sys/baseuser.html");
    }

    @RequestMapping("/page")
    @ResponseBody
    public GridPage page(GridPageRequest gridPageRequest, Long orgId, String searchText) {
        if(orgId!=null){
            return baseUserService.page(gridPageRequest.pageable(), orgId, searchText);
        }else{
            return new GridPage();
        }
    }

    @RequestMapping("/findone")
    @ResponseBody
    public Object findOne(Long id) {
        BaseUser entity = baseUserService.findOne(id);
        return entity;
    }

    @RequestMapping("/save")
    @ResponseBody
    public Object save(BaseUser entity) {
        JsonResult msg = baseUserService.checkRepeat(entity);
        if (!msg.isSuccess()) {
            return JsonResult.result(msg);
        } else {
            return JsonResult.success(baseUserService.save(entity));
        }
    }

    @RequestMapping("/logicDelete")
    @ResponseBody
    public Object del(Long id) {
        baseUserService.logicDelete(id);
        return JsonResult.success();
    }

    @RequestMapping("/resetPassword")
    @ResponseBody
    public JsonResult resetPassword(Long id) {
        baseUserService.resetPassword(id);
        return JsonResult.success("密码已被重置为:" + frameService.getParamStr(CoreInitParams.USER_DEF_PASSWORD));
    }


    @RequestMapping("/updateUserInfo")
    @ResponseBody
    public Object updateUserInfo(BaseUser entity) {
        return JsonResult.success(baseUserService.updateUserInfo(entity));
    }

    @RequestMapping("/changePassword")
    @ResponseBody
    public JsonResult changePassword(String oldPassword, String newPassword1, String newPassword2) {
        LoginUser loginUser = getLoginUser();
        if (loginUser.isSuperAdmin()) {
            return JsonResult.error("当前用户为超级管理员,只允许在配置文件中修改密码");
        }
        if (StrUtil.isEmpty(oldPassword)) {
            return JsonResult.error("原密码不能为空");
        }
        if (StrUtil.isEmpty(newPassword1)) {
            return JsonResult.error("新密码不能为空");
        }
        if (StrUtil.isEmpty(newPassword2)) {
            return JsonResult.error("新密码确认不能为空");
        }
        if (!StrUtil.equals(newPassword1, newPassword2)) {
            return JsonResult.error("两次密码输入不一致,请核对");
        } else {
            return baseUserService.changePassword(loginUser.getUserId(), oldPassword, newPassword1);
        }
    }

//	@RequestMapping( "/updateUser")
//	@ResponseBody
//	public Object updateUser(BaseUser entity) {
//		return baseUserService.updateUser(entity);
//	}*/
}
