package com.kdgcsoft.scrdc.frame.webframe.sys.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.FrameHelper;
import com.kdgcsoft.scrdc.frame.webframe.core.controller.BaseController;
import com.kdgcsoft.scrdc.frame.webframe.core.model.*;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseRole;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseOrgService;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BasePermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:25
 * @version: 1.0
 **/
@Controller
@RequestMapping("/sys/permission")
public class BasePermissionController extends BaseController {
    @Autowired
    private BasePermissionService baseRoleService;

    @Autowired
    private BaseOrgService baseOrgService;

    @RequestMapping("/index")
    public ModelAndView index() {
        Map<String,Object> model=MapUtil.newHashMap();
        if(StrUtil.equals(frameService.getParamStr("ROLE_MANAGE_MODE"),"2")){
            model.put("roleType",baseRoleService.userTopRoleType(getLoginUser()));
        }else{
            model.put("roleType", BaseRole.RoleType.SUPER_ADMIN);
        }

        return renderView("/sys/basepermission.html",model);
    }

    @RequestMapping("/allowRoleType")
    @ResponseBody
    public Object allowRoleType() {
        List<UiComboNode> list=new ArrayList<>();
        if(StrUtil.equals(frameService.getParamStr("ROLE_MANAGE_MODE"),"2")){
            BaseRole.RoleType roleType=baseRoleService.userTopRoleType(getLoginUser());
            if(roleType== BaseRole.RoleType.SUPER_ADMIN){
                list.add(new UiComboNode("超级管理员",BaseRole.RoleType.SUPER_ADMIN.name()));
                list.add(new UiComboNode("管理员",BaseRole.RoleType.COMMON_ADMIN.name()));
                list.add(new UiComboNode("普通角色",BaseRole.RoleType.COMMON_ROLE.name()));
            }else if(roleType== BaseRole.RoleType.COMMON_ADMIN){
                list.add(new UiComboNode("管理员",BaseRole.RoleType.COMMON_ADMIN.name()));
                list.add(new UiComboNode("普通角色",BaseRole.RoleType.COMMON_ROLE.name()));
            }else{
                list.add(new UiComboNode("普通角色",BaseRole.RoleType.COMMON_ROLE.name()));
            }
        }else{
            list.add(new UiComboNode("超级管理员",BaseRole.RoleType.SUPER_ADMIN.name()));
            list.add(new UiComboNode("管理员",BaseRole.RoleType.COMMON_ADMIN.name()));
            list.add(new UiComboNode("普通角色",BaseRole.RoleType.COMMON_ROLE.name()));
        }
        return list;
    }

    @RequestMapping("/userOrgTree")
    @ResponseBody
    public Object userOrgTree() {
        LoginUser user=getLoginUser();
        List<UiTreeNode> list;
        if(user.isSuperAdmin()){
             list= FrameHelper.buildTreeNode(baseOrgService.tree());
        }else{
            list= FrameHelper.buildTreeNode(baseOrgService.tree(),user.getOrgId().toString());
        }
        return list;
    }

    /***
     * 获取当前登陆人可以分配的权限列表,
     * 如果是超级管理员则是全部菜单
     * 其他用户则是自己拥有的所有普通管理员角色所分配的权限合集
     * @return
     */
    @RequestMapping("/userPermissionTree")
    @ResponseBody
    public List<UiTreeNode> userPermissionTree() {
        return baseRoleService.userPermissionTree(getLoginUser());
    }

    @RequestMapping("/roletree")
    @ResponseBody
    public Object roletree(Long orgId) {
        if(StrUtil.equals(frameService.getParamStr("ROLE_MANAGE_MODE"),"2")){
            BaseRole.RoleType roleType=baseRoleService.userTopRoleType(getLoginUser());
            if(roleType== BaseRole.RoleType.SUPER_ADMIN){
                return baseRoleService.tree(orgId);
            }else if(roleType== BaseRole.RoleType.COMMON_ADMIN){
                return baseRoleService.treeByRoleType(orgId,CollUtil.newArrayList(BaseRole.RoleType.COMMON_ADMIN.ordinal(),BaseRole.RoleType.COMMON_ROLE.ordinal()));
            }else{
                return baseRoleService.treeByRoleType(orgId,CollUtil.newArrayList(BaseRole.RoleType.COMMON_ROLE.ordinal()));
            }
        }else{
            return baseRoleService.tree(orgId);
        }

    }


    @RequestMapping("/findone")
    @ResponseBody
    public Object findOne(Long id) {
        return baseRoleService.findOne(id);
    }

    @RequestMapping("/save")
    @ResponseBody
    public Object save(BaseRole entity) {
        return JsonResult.success(baseRoleService.save(entity));
    }


    @RequestMapping("/deleteRole")
    @ResponseBody
    public Object deleteRole(Long id) {
        baseRoleService.deleteRole(id);
        return JsonResult.success();
    }


    @RequestMapping("/userInRoleAndOrg")
    @ResponseBody
    public GridPage roleuserIn(GridPageRequest gridPageRequest, Long orgId, Long roleId, String searchText) {
        return baseRoleService.userInRoleAndOrg(gridPageRequest.pageable(), orgId, roleId, searchText);
    }

    @RequestMapping("/userNotInRoleAndOrg")
    @ResponseBody
    public GridPage roleuserOut(GridPageRequest gridPageRequest, Long orgId, Long roleId, String searchText) {
        return baseRoleService.userNotInRoleAndOrg(gridPageRequest.pageable(), orgId, roleId, searchText);
    }


    @RequestMapping("/checkin")
    @ResponseBody
    public Object checkin(Long roleId, Long[] userids) {
        baseRoleService.checkin(roleId, userids);
        return JsonResult.success();
    }

    @RequestMapping("/checkout")
    @ResponseBody
    public Object checkout(Long roleId, Long[] userids) {
        baseRoleService.checkout(roleId, CollUtil.toList(userids));
        return JsonResult.success();
    }


    @RequestMapping("/rolePermission")
    @ResponseBody
    public Object rolePermission(Long roleId) {
        return baseRoleService.rolePermission(roleId);
    }


    @RequestMapping("/adminPermission")
    @ResponseBody
    public Object adminPermission(Long roleId) {
        return baseRoleService.adminPermission(roleId);
    }

    @RequestMapping("/saveRolePermission")
    @ResponseBody
    public Object saveRolePermission(Long roleId,String[] allCodes, String[] checkedCodes) {
        baseRoleService.saveRolePermission(roleId,allCodes, checkedCodes);
        return JsonResult.success("保存成功");
    }

    @RequestMapping("/saveAdminPermission")
    @ResponseBody
    public Object saveAdminPermission(Long roleId,String[] allCodes, String[] checkedCodes) {
        baseRoleService.saveAdminPermission(roleId,allCodes, checkedCodes);
        return JsonResult.success("保存成功");
    }
}
