package com.kdgcsoft.scrdc.frame.webframe.sys.controller;

import com.kdgcsoft.scrdc.frame.webframe.core.controller.BaseController;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseOrg;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseOrgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * @description:
 * @author: fyin
 * @date: 2018/9/6/006 14:11
 * @version: 1.0
 **/
@Controller
@RequestMapping("/sys/baseorg")
public class BaseOrgController extends BaseController {
	@Autowired
	private BaseOrgService baseOrgService;

	@RequestMapping("/index")
	public ModelAndView index() {
		return renderView("/sys/baseorg.html");
	}

	@RequestMapping("/tree")
	@ResponseBody
	public Object tree() {
		return baseOrgService.tree();
	}
	
	@RequestMapping("/save")
	@ResponseBody
	public JsonResult save(BaseOrg entity) {
		return JsonResult.success(baseOrgService.save(entity));
	}
	
	@RequestMapping("/findone")
	@ResponseBody
	public Object findOne(Long id) {
		return baseOrgService.findById(id);
	}


	@RequestMapping("/logicDelete")
	@ResponseBody
	public JsonResult logicDelete(Long id) {
		baseOrgService.logicDeleteCascade(id);
		return JsonResult.success();

	}
	
}
