package com.kdgcsoft.scrdc.frame.webframe.sys.controller;

import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.controller.BaseController;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseDept;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/22/022 15:21
 * @version: 1.0
 **/

@Controller
@RequestMapping("/sys/basedept")
public class BaseDeptController extends BaseController {
    @Autowired
    private BaseDeptService baseDeptService;

    @RequestMapping("/index")
    public ModelAndView index() {
        return renderView("/sys/basedept.html");
    }

    @RequestMapping("/tree")
    @ResponseBody
    public Object tree(Long orgId) {
        if(orgId!=null){
            return baseDeptService.tree(orgId);
        }else{
            return MapUtil.newHashMap();
        }

    }

    @RequestMapping("/findone")
    @ResponseBody
    public Object findOne(Long id) {
        return baseDeptService.findOne(id);
    }

    @RequestMapping("/save")
    @ResponseBody
    public Object save(BaseDept entity) {
        return JsonResult.success(baseDeptService.save(entity));
    }


    @RequestMapping("/logicDelete")
    @ResponseBody
    public Object logicDelete(Long id) {
        baseDeptService.logicDeleteCascade(id);
        return JsonResult.success("操作成功");
    }
}
