package com.kdgcsoft.scrdc.frame.webframe.sys.config;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.crypto.SecureUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.exception.LoginException;
import com.kdgcsoft.scrdc.frame.webframe.core.model.LoginUser;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseDept;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseOrg;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseUser;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseDeptService;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseOrgService;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BasePermissionService;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseUserService;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;

/**
 * @author fyin
 * @createTime 2018/7/20/020 15:32
 * @description 检测用户名密码 密码采用md5加密的问题
 */
@Component
public class SysBaseUserRealm extends AuthorizingRealm {
    @Autowired
    BaseUserService baseUserService;
    @Autowired
    BaseOrgService baseOrgService;
    @Autowired
    BaseDeptService baseDeptService;
    @Autowired
    BasePermissionService baseRoleService;

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        LoginUser loginUser = (LoginUser) principalCollection.asList().get(0);
        SimpleAuthorizationInfo sai = new SimpleAuthorizationInfo(new HashSet<>(loginUser.getRoles()));
        
        if(loginUser.isSuperAdmin() && CollectionUtil.isEmpty(loginUser.getPermissions())) {
            loginUser.setPermissions(baseRoleService.superAdminPermissions());
        }
        sai.setRoles(new HashSet<>(loginUser.getRoles()));
        sai.setStringPermissions(new HashSet<>(loginUser.getPermissions()));
        return sai;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken) authenticationToken;
        List<BaseUser> userlist = baseUserService.findByLoginCode(token.getUsername());
        if (userlist.size() > 0) {
            for (BaseUser user : userlist) {
                String password = Base64Decoder.decodeStr(String.valueOf(token.getPassword()));
                String userPassword = SecureUtil.sha256(user.getLoginPassword());
                if (userPassword.equals(password)) {
                    LoginUser loginuser = new LoginUser();
                    loginuser.setUserId(user.getUserId());
                    loginuser.setUserName(user.getUserName());
                    loginuser.setLoginCode(token.getUsername());
                    if (user.getOrgId() != null) {
                        BaseOrg org = baseOrgService.findById(user.getOrgId());
                        if (org != null) {
                            loginuser.setOrgId(org.getOrgId());
                            loginuser.setOrgName(org.getOrgName());
                        }
                        BaseDept dept = baseDeptService.findOne(user.getDeptId());
                        if (dept != null) {
                            loginuser.setDeptId(dept.getDeptId());
                            loginuser.setDeptName(dept.getDeptName());
                        }
                    }
                    loginuser.setSuperAdmin(baseRoleService.isSuperAdminInDb(user.getUserId()));
                    loginuser.setPermissions(baseRoleService.userPermissions(user.getUserId()));
                    loginuser.setRoles(baseRoleService.userRoles(user.getUserId()));
                    loginuser.setAccessMenus(baseRoleService.userAccessMenus(loginuser.getPermissions()));
                    return new SimpleAuthenticationInfo(loginuser, token.getPassword(), super.getName());
                }
            }
            throw new LoginException("用户名密码出错");
        } else {
            throw new LoginException("用户名密码出错");
        }

    }
}
