package com.kdgcsoft.scrdc.frame.webframe.sys.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.EmbedMenu;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.InitParam;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.interfaces.FrameExtConfig;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/16/016 15:03
 * @version: 1.0
 **/
@Configuration
public class FrameSysExtConfig implements FrameExtConfig {

    @Autowired
    private ShiroCasProperties shiroCasProperties;

    @Override
    public String modelCode() {
        return "frame-sys";
    }

    @Override
    public List<InitParam> initParams() {
        List<InitParam> list = new ArrayList<>();

        InitParam roleType = new InitParam(InitParam.GroupType.PARAMS);
        roleType.setKey("ROLE_MANAGE_MODE");
        roleType.setLabel("权限管理模式");
        roleType.setTips("基本模式:拥有角色权限管理页面访问权限的人即可随意的分配所有人员的权限<br>" + "层级管理模式:管理员可以为其他管理员(包括下级)进行可授权限的分配");
        roleType.setType(InitParam.ParamType.SELECT);
        roleType.addOption("基本模式", "1");
        roleType.addOption("层级管理模式", "2");
        roleType.setDefaultVal("1");
        roleType.setOrder(10);
        list.add(roleType);
        return list;
    }

    @Override
    public List<EmbedMenu> embedMenu() {
        EmbedMenu basesettingsmenu = new EmbedMenu("SYS_SETTINGS", "系统管理", "NULL", "icon-server", Integer.MAX_VALUE - 1);
        EmbedMenu baseorg = new EmbedMenu("BASE_ORG", "组织机构管理", "sys/baseorg/index", "icon-file-o", 1);
        EmbedMenu basedept = new EmbedMenu("BASE_DEPT", "部门管理", "sys/basedept/index", "icon-file-o", 2);
        EmbedMenu baseuser = new EmbedMenu("BASE_USER", "用户管理", "sys/baseuser/index", "icon-file-o", 3);
        EmbedMenu baseuserrole = new EmbedMenu("BASE_USER_ROLE", "角色权限管理", "sys/permission/index", "icon-file-o", 4);
        basesettingsmenu.addChild(baseorg);
        basesettingsmenu.addChild(basedept);
        basesettingsmenu.addChild(baseuser);
        basesettingsmenu.addChild(baseuserrole);
        return CollUtil.newArrayList(basesettingsmenu);
    }


    @Override
    public Class shiroRealm() {
        return shiroCasProperties.isCasEnable() ? CasShiroRealm.class : SysBaseUserRealm.class;
    }

    @Override
    public int order() {
        return 1;
    }
}
