package com.kdgcsoft.scrdc.frame.webframe.sys.config;


import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroCasProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.exception.LoginException;
import com.kdgcsoft.scrdc.frame.webframe.core.model.LoginUser;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseDept;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseOrg;
import com.kdgcsoft.scrdc.frame.webframe.sys.entity.BaseUser;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseDeptService;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseOrgService;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BasePermissionService;
import com.kdgcsoft.scrdc.frame.webframe.sys.service.BaseUserService;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * cas接入认证 此方法已过时 后面改为pac4j
 */
@Component
public class CasShiroRealm extends CasRealm {

    private static final Logger LOG = LoggerFactory.getLogger(CasShiroRealm.class);

    @Autowired
    BaseUserService baseUserService;
    @Autowired
    BaseOrgService baseOrgService;
    @Autowired
    BaseDeptService baseDeptService;
    @Autowired
    BasePermissionService baseRoleService;
    @Autowired
    private ShiroCasProperties shiroCasProperties;

    @PostConstruct
    public void initProperties() {
        LOG.info("配置基本属性");
        this.setDefaultRoles("ROLE_USER");
        this.setCasServerUrlPrefix(shiroCasProperties.getCasServerUrl());
        this.setCasService(shiroCasProperties.getService() + "toIndex");
    }

    /**
     * 授权
     */
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        LoginUser loginUser = (LoginUser) principals.asList().get(0);
        SimpleAuthorizationInfo sai = new SimpleAuthorizationInfo(new HashSet<>(loginUser.getRoles()));
        if (loginUser.isSuperAdmin() && CollectionUtil.isEmpty(loginUser.getPermissions())) {
            loginUser.setPermissions(baseRoleService.superAdminPermissions());
        }
        sai.setStringPermissions(new HashSet<>(loginUser.getPermissions()));
        return sai;
    }

    /**
     * 认证
     */
    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        LOG.info("进入doGetAuthenticationInfo");
        try {
            CasToken casToken = (CasToken) token;
            if (token == null) {
                return null;
            }
            String ticket = (String) casToken.getCredentials();
            if (!StringUtils.hasText(ticket)) {
                return null;
            }
            TicketValidator ticketValidator = ensureTicketValidator();
            Assertion casAssertion;
            try {
                casAssertion = ticketValidator.validate(ticket, getCasService());
            } catch (TicketValidationException e) {
                throw new LoginException("用户名密码出错", e);
            }
            LOG.info("远程验证通过");
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String userName = casPrincipal.getName();
            Map<String, Object> attributes = casPrincipal.getAttributes();
            casToken.setUserId(userName);
            String rememberMeAttributeName = getRememberMeAttributeName();
            String rememberMeStringValue = (String) attributes.get(rememberMeAttributeName);
            boolean isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
            if (isRemembered) {
                casToken.setRememberMe(true);
            }
            List<BaseUser> userlist = baseUserService.findByLoginCode(userName);
            if (CollUtil.isEmpty(userlist)) {
                throw new LoginException("用户名不存在！");
            }
            BaseUser user = userlist.get(0);
            LoginUser loginuser = new LoginUser();
            loginuser.setUserId(user.getUserId());
            loginuser.setUserName(user.getUserName());
            loginuser.setLoginCode(userName);
            if (user.getOrgId() != null) {
                BaseOrg org = baseOrgService.findById(user.getOrgId());
                if (org != null) {
                    loginuser.setOrgId(org.getOrgId());
                    loginuser.setOrgName(org.getOrgName());
                }
                BaseDept dept = baseDeptService.findOne(user.getDeptId());
                if (dept != null) {
                    loginuser.setDeptId(dept.getDeptId());
                    loginuser.setDeptName(dept.getDeptName());
                }
            }
            loginuser.setSuperAdmin(baseRoleService.isSuperAdminInDb(user.getUserId()));
            loginuser.setPermissions(baseRoleService.userPermissions(user.getUserId()));
            loginuser.setRoles(baseRoleService.userRoles(user.getUserId()));
            loginuser.setAccessMenus(baseRoleService.userAccessMenus(loginuser.getPermissions()));

            List<?> principals = CollectionUtils.asList(loginuser, attributes);
            PrincipalCollection principalCollection = new SimplePrincipalCollection(principals, getName());
            return new SimpleAuthenticationInfo(principalCollection, ticket);
        } catch (Exception e) {
            e.printStackTrace();
            throw new AuthenticationException(e.getMessage(), e);
        }
    }
}
