-- ----------------------------
-- Table structure for base_dept
-- ----------------------------
CREATE TABLE base_dept (
	dept_id NUMBER (20, 0) NOT NULL ENABLE,
	dept_pid NUMBER (20, 0),
	org_id NUMBER (20, 0) NOT NULL ENABLE,
	dept_code NVARCHAR2 (50),
	dept_full_name NVARCHAR2 (50),
	dept_name NVARCHAR2 (50),
	order_no NUMBER (11, 0),
	logic_delete NUMBER (11, 0),
	create_by NUMBER (20, 0),
	create_time DATE,
	modify_by NUMBER (20, 0),
	modify_time DATE,
	PRIMARY KEY (dept_id)
);

-- ----------------------------
-- Table structure for base_org
-- ----------------------------
CREATE TABLE base_org (
	org_id NUMBER (20, 0) NOT NULL ENABLE,
	org_pid NUMBER (20, 0),
	org_code NVARCHAR2 (50),
	org_full_name NVARCHAR2 (50),
	org_name NVARCHAR2 (50),
	order_no NUMBER (11, 0),
	logic_delete NUMBER (11, 0),
	create_by NUMBER (20, 0),
	create_time DATE,
	modify_by NUMBER (20, 0),
	modify_time DATE,
	PRIMARY KEY (org_id)
);

-- ----------------------------
-- Table structure for base_role
-- ----------------------------
CREATE TABLE base_role (
	role_id NUMBER (20, 0) NOT NULL ENABLE,
	org_id NUMBER (20, 0),
	role_name NVARCHAR2 (255),
	role_type NUMBER (11, 0) NOT NULL ENABLE,
	logic_delete NUMBER (11, 0),
	create_by NUMBER (20, 0),
	create_time DATE,
	modify_by NUMBER (20, 0),
	modify_time DATE,
	PRIMARY KEY (role_id)
);

-- ----------------------------
-- Table structure for base_role_user
-- ----------------------------
CREATE TABLE base_role_user (
	role_user_id NUMBER (20, 0) NOT NULL ENABLE,
	role_id NUMBER (20, 0) NOT NULL ENABLE,
	user_id NUMBER (20, 0) NOT NULL ENABLE,
	logic_delete NUMBER (11, 0),
	create_by NUMBER (20, 0),
	create_time DATE,
	modify_by NUMBER (20, 0),
	modify_time DATE,
	PRIMARY KEY (role_user_id)
);

-- ----------------------------
-- Table structure for base_role_permission
-- ----------------------------
CREATE TABLE base_role_permission (
	role_permisson_id NUMBER (20, 0) NOT NULL ENABLE,
	role_id NUMBER (20, 0),
	permission_code NVARCHAR2 (80),
	logic_delete NUMBER (11, 0),
	create_by NUMBER (20, 0),
	create_time DATE,
	modify_by NUMBER (20, 0),
	modify_time DATE,
	PRIMARY KEY (role_permisson_id)
);

-- ----------------------------
-- Table structure for base_admin_permission
-- ----------------------------
CREATE TABLE base_admin_permission (
	role_permisson_id NUMBER (20, 0) NOT NULL ENABLE,
	role_id NUMBER (20, 0),
	permission_code NVARCHAR2 (80),
	logic_delete NUMBER (11, 0),
	create_by NUMBER (20, 0),
	create_time DATE,
	modify_by NUMBER (20, 0),
	modify_time DATE,
	PRIMARY KEY (role_permisson_id)
);

-- ----------------------------
-- Table structure for base_user
-- ----------------------------
CREATE TABLE base_user (
	user_id NUMBER (20, 0) NOT NULL ENABLE,
	org_id NUMBER (20, 0) NOT NULL ENABLE,
	dept_id NUMBER (20, 0) NOT NULL ENABLE,
	user_code NVARCHAR2 (80),
	user_name NVARCHAR2 (80),
	login_code NVARCHAR2 (80),
	login_password NVARCHAR2 (80),
	sex NUMBER (11, 0),
	mobliephone NVARCHAR2 (80),
	email NVARCHAR2 (80),
	account_state NUMBER (11, 0),
	logic_delete NUMBER (11, 0),
	create_by NUMBER (20, 0),
	create_time DATE,
	modify_by NUMBER (20, 0),
	modify_time DATE,
	PRIMARY KEY (user_id)
);
