--
-- Name: BASE_DEPT; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_DEPT" (
    "DEPT_ID" NUMERIC(20,0) NOT NULL,
    "DEPT_PID" NUMERIC(20,0),
    "ORG_ID" NUMERIC(20,0) NOT NULL,
    "DEPT_CODE" CHARACTER VARYING(50 char),
    "DEPT_FULL_NAME" CHARACTER VARYING(50 char),
    "DEPT_NAME" CHARACTER VARYING(50 char),
    "ORDER_NO" NUMERIC(11,0),
    "LOGIC_DELETE" NUMERIC(11,0),
    "CREATE_BY" NUMERIC(20,0),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE,
    "MODIFY_BY" NUMERIC(20,0),
    "MODIFY_TIME" TIMESTAMP WITHOUT TIME ZONE
);
ALTER TABLE ONLY "BASE_DEPT" ADD CONSTRAINT "BASE_DEPT_PKEY" PRIMARY KEY ("DEPT_ID");

--
-- Name: BASE_ORG; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_ORG" (
    "ORG_ID" NUMERIC(20,0) NOT NULL,
    "ORG_PID" NUMERIC(20,0),
    "ORG_CODE" CHARACTER VARYING(50 char),
    "ORG_FULL_NAME" CHARACTER VARYING(50 char),
    "ORG_NAME" CHARACTER VARYING(50 char),
    "ORDER_NO" NUMERIC(11,0),
    "LOGIC_DELETE" NUMERIC(11,0),
    "CREATE_BY" NUMERIC(20,0),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE,
    "MODIFY_BY" NUMERIC(20,0),
    "MODIFY_TIME" TIMESTAMP WITHOUT TIME ZONE
);
ALTER TABLE ONLY "BASE_ORG" ADD CONSTRAINT "BASE_ORG_PKEY" PRIMARY KEY ("ORG_ID");

--
-- Name: BASE_PERMISSION; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_PERMISSION" (
    "PERM_ID" NUMERIC(28,0) NOT NULL,
    "PERM_CODE" CHARACTER VARYING(64 char) NOT NULL,
    "PERM_PID" NUMERIC(28,0) NOT NULL,
    "PERM_NAME" CHARACTER VARYING(64 char),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE NOT NULL
);
ALTER TABLE ONLY "BASE_PERMISSION" ADD CONSTRAINT "BASE_PERMISSION_PKEY" PRIMARY KEY ("PERM_ID");

--
-- Name: BASE_ROLE; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_ROLE" (
    "ROLE_ID" NUMERIC(20,0) NOT NULL,
    "ORG_ID" NUMERIC(20,0),
    "ROLE_NAME" CHARACTER VARYING(255 char),
    "ROLE_TYPE" NUMERIC(11,0) NOT NULL,
    "LOGIC_DELETE" NUMERIC(11,0),
    "CREATE_BY" NUMERIC(20,0),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE,
    "MODIFY_BY" NUMERIC(20,0),
    "MODIFY_TIME" TIMESTAMP WITHOUT TIME ZONE
);
ALTER TABLE ONLY "BASE_ROLE" ADD CONSTRAINT "BASE_ROLE_PKEY" PRIMARY KEY ("ROLE_ID");

--
-- Name: BASE_ROLE_PERMISSION; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_ROLE_PERMISSION" (
    "ROLE_PERMISSON_ID" NUMERIC(20,0) NOT NULL,
    "ROLE_ID" NUMERIC(20,0),
    "PERMISSION_CODE" CHARACTER VARYING(80 char),
    "LOGIC_DELETE" NUMERIC(11,0),
    "CREATE_BY" NUMERIC(20,0),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE,
    "MODIFY_BY" NUMERIC(20,0),
    "MODIFY_TIME" TIMESTAMP WITHOUT TIME ZONE
);
ALTER TABLE ONLY "BASE_ROLE_PERMISSION" ADD CONSTRAINT "BASE_ROLE_PERMISSION_PKEY" PRIMARY KEY ("ROLE_PERMISSON_ID");

--
-- Name: BASE_ROLE_USER; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_ROLE_USER" (
    "ROLE_USER_ID" NUMERIC(20,0) NOT NULL,
    "ROLE_ID" NUMERIC(20,0) NOT NULL,
    "USER_ID" NUMERIC(20,0) NOT NULL,
    "LOGIC_DELETE" NUMERIC(11,0),
    "CREATE_BY" NUMERIC(20,0),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE,
    "MODIFY_BY" NUMERIC(20,0),
    "MODIFY_TIME" TIMESTAMP WITHOUT TIME ZONE
);
ALTER TABLE ONLY "BASE_ROLE_USER" ADD CONSTRAINT "BASE_ROLE_USER_PKEY" PRIMARY KEY ("ROLE_USER_ID");

--
-- Name: BASE_USER; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_USER" (
    "USER_ID" NUMERIC(20,0) NOT NULL,
    "ORG_ID" NUMERIC(20,0) NOT NULL,
    "DEPT_ID" NUMERIC(20,0) NOT NULL,
    "USER_CODE" CHARACTER VARYING(80 char),
    "USER_NAME" CHARACTER VARYING(80 char),
    "LOGIN_CODE" CHARACTER VARYING(80 char),
    "LOGIN_PASSWORD" CHARACTER VARYING(80 char),
    "SEX" NUMERIC(11,0),
    "MOBLIEPHONE" CHARACTER VARYING(80 char),
    "EMAIL" CHARACTER VARYING(80 char),
    "ACCOUNT_STATE" NUMERIC(11,0),
    "LOGIC_DELETE" NUMERIC(11,0),
    "CREATE_BY" NUMERIC(20,0),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE,
    "MODIFY_BY" NUMERIC(20,0),
    "MODIFY_TIME" TIMESTAMP WITHOUT TIME ZONE
);
ALTER TABLE ONLY "BASE_USER" ADD CONSTRAINT "BASE_USER_PKEY" PRIMARY KEY ("USER_ID");

--
-- Name: BASE_ADMIN_PERMISSION; Type: TABLE; Schema: PFT; Owner: PFT
--

CREATE TABLE "BASE_ADMIN_PERMISSION" (
    "ROLE_PERMISSON_ID" NUMERIC(20,0) NOT NULL,
    "ROLE_ID" NUMERIC(20,0),
    "PERMISSION_CODE" CHARACTER VARYING(80 char),
    "LOGIC_DELETE" NUMERIC(11,0),
    "CREATE_BY" NUMERIC(20,0),
    "CREATE_TIME" TIMESTAMP WITHOUT TIME ZONE,
    "MODIFY_BY" NUMERIC(20,0),
    "MODIFY_TIME" TIMESTAMP WITHOUT TIME ZONE
);
ALTER TABLE ONLY "BASE_ADMIN_PERMISSION" ADD CONSTRAINT "BASE_ADMIN_PERMISSION_PKEY" PRIMARY KEY ("ROLE_PERMISSON_ID");
