DROP TABLE IF EXISTS "BASE_DEPT";
CREATE TABLE "BASE_DEPT"
(
"DEPT_ID" BIGINT NOT NULL,
"DEPT_PID" BIGINT,
"ORG_ID" BIGINT NOT NULL,
"DEPT_CODE" VARCHAR(50),
"DEPT_FULL_NAME" VARCHAR(50),
"DEPT_NAME" VARCHAR(50),
"ORDER_NO" INT,
"LOGIC_DELETE" INT,
"CREATE_BY" BIGINT,
"CREATE_TIME" TIMESTAMP(0),
"MODIFY_BY" BIGINT,
"MODIFY_TIME" TIMESTAMP(0),
NOT CLUSTER PRIMARY KEY("DEPT_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "INDEX817214302575100" ON "BASE_DEPT"("DEPT_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

DROP TABLE IF EXISTS "BASE_ORG";
CREATE TABLE "BASE_ORG"
(
"ORG_ID" BIGINT NOT NULL,
"ORG_PID" BIGINT,
"ORG_CODE" VARCHAR(50),
"ORG_FULL_NAME" VARCHAR(50),
"ORG_NAME" VARCHAR(50),
"ORDER_NO" INT,
"LOGIC_DELETE" INT,
"CREATE_BY" BIGINT,
"CREATE_TIME" TIMESTAMP(0),
"MODIFY_BY" BIGINT,
"MODIFY_TIME" TIMESTAMP(0),
NOT CLUSTER PRIMARY KEY("ORG_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "INDEX817214169013000" ON "BASE_ORG"("ORG_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

DROP TABLE IF EXISTS "BASE_PERMISSION";
CREATE TABLE "BASE_PERMISSION"
(
"PERM_ID" DECIMAL(28,0) NOT NULL,
"PERM_CODE" VARCHAR(64) NOT NULL,
"PERM_PID" DECIMAL(28,0) NOT NULL,
"PERM_NAME" VARCHAR(64),
"CREATE_TIME" TIMESTAMP(0) NOT NULL,
NOT CLUSTER PRIMARY KEY("PERM_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

COMMENT ON TABLE "BASE_PERMISSION" IS '细粒度权限表';
COMMENT ON COLUMN "BASE_PERMISSION"."PERM_ID" IS '权限ID';
COMMENT ON COLUMN "BASE_PERMISSION"."PERM_CODE" IS '权限编码';
COMMENT ON COLUMN "BASE_PERMISSION"."PERM_PID" IS '权限父ID';
COMMENT ON COLUMN "BASE_PERMISSION"."PERM_NAME" IS '权限名称';
COMMENT ON COLUMN "BASE_PERMISSION"."CREATE_TIME" IS '创建时间';


CREATE  INDEX "IDX_BASEPERMISSION_PERMCODE" ON "BASE_PERMISSION"("PERM_CODE" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;
CREATE  INDEX "IDX_BASEPERMISSION_PERMPID" ON "BASE_PERMISSION"("PERM_PID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;
CREATE UNIQUE  INDEX "INDEX817214156744500" ON "BASE_PERMISSION"("PERM_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

DROP TABLE IF EXISTS "BASE_ROLE";
CREATE TABLE "BASE_ROLE"
(
"ROLE_ID" BIGINT NOT NULL,
"ORG_ID" BIGINT,
"ROLE_NAME" VARCHAR(255),
"ROLE_TYPE" INT NOT NULL,
"LOGIC_DELETE" INT,
"CREATE_BY" BIGINT,
"CREATE_TIME" TIMESTAMP(0),
"MODIFY_BY" BIGINT,
"MODIFY_TIME" TIMESTAMP(0),
NOT CLUSTER PRIMARY KEY("ROLE_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "INDEX817214123217600" ON "BASE_ROLE"("ROLE_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

DROP TABLE IF EXISTS "BASE_ROLE_PERMISSION";
CREATE TABLE "BASE_ROLE_PERMISSION"
(
"ROLE_PERMISSON_ID" BIGINT NOT NULL,
"ROLE_ID" BIGINT,
"PERMISSION_CODE" VARCHAR(80),
"LOGIC_DELETE" INT,
"CREATE_BY" BIGINT,
"CREATE_TIME" TIMESTAMP(0),
"MODIFY_BY" BIGINT,
"MODIFY_TIME" TIMESTAMP(0),
NOT CLUSTER PRIMARY KEY("ROLE_PERMISSON_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "INDEX817214119582500" ON "BASE_ROLE_PERMISSION"("ROLE_PERMISSON_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

DROP TABLE IF EXISTS "BASE_ROLE_USER";
CREATE TABLE "BASE_ROLE_USER"
(
"ROLE_USER_ID" BIGINT NOT NULL,
"ROLE_ID" BIGINT NOT NULL,
"USER_ID" BIGINT NOT NULL,
"LOGIC_DELETE" INT,
"CREATE_BY" BIGINT,
"CREATE_TIME" TIMESTAMP(0),
"MODIFY_BY" BIGINT,
"MODIFY_TIME" TIMESTAMP(0),
NOT CLUSTER PRIMARY KEY("ROLE_USER_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "INDEX817214115711500" ON "BASE_ROLE_USER"("ROLE_USER_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

DROP TABLE IF EXISTS "BASE_USER";
CREATE TABLE "BASE_USER"
(
"USER_ID" BIGINT NOT NULL,
"ORG_ID" BIGINT NOT NULL,
"DEPT_ID" BIGINT NOT NULL,
"USER_CODE" VARCHAR(80),
"USER_NAME" VARCHAR(80),
"LOGIN_CODE" VARCHAR(80),
"LOGIN_PASSWORD" VARCHAR(80),
"SEX" INT,
"MOBLIEPHONE" VARCHAR(80),
"EMAIL" VARCHAR(80),
"ACCOUNT_STATE" INT,
"LOGIC_DELETE" INT,
"CREATE_BY" BIGINT,
"CREATE_TIME" TIMESTAMP(0),
"MODIFY_BY" BIGINT,
"MODIFY_TIME" TIMESTAMP(0),
NOT CLUSTER PRIMARY KEY("USER_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "INDEX817214103701700" ON "BASE_USER"("USER_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

DROP TABLE IF EXISTS "BASE_ADMIN_PERMISSION";
CREATE TABLE "BASE_ADMIN_PERMISSION"
(
"ROLE_PERMISSON_ID" BIGINT NOT NULL,
"ROLE_ID" BIGINT,
"PERMISSION_CODE" VARCHAR(80),
"LOGIC_DELETE" INT,
"CREATE_BY" BIGINT,
"CREATE_TIME" TIMESTAMP(0),
"MODIFY_BY" BIGINT,
"MODIFY_TIME" TIMESTAMP(0),
NOT CLUSTER PRIMARY KEY("ROLE_PERMISSON_ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "INDEX817214307059000" ON "BASE_ADMIN_PERMISSION"("ROLE_PERMISSON_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;
