/*
 * Decompiled with CFR 0.152.
 */
package cn.trust.sign.client.utils;

import cn.trust.sign.client.constants.PDFConstant;
import cn.trust.sign.client.utils.EncUtils;
import cn.trust.sign.client.utils.FastBase64;
import cn.trust.sign.client.utils.JsonUtils;
import com.dovtrust.client.exceptions.ParameterInvalidException;
import com.dovtrust.client.exceptions.ParameterOutRangeException;
import com.dovtrust.client.log.LoggerUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class FileUtils {
    private static String localIP = "127.0.0.1";

    public static int checkTemplate(String templateNo) throws ParameterInvalidException, ParameterOutRangeException {
        String result = "";
        if (templateNo == null || templateNo.trim().length() == 0) {
            result = "\u7b7e\u7ae0\u89c4\u5219\u53f7\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700004";
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        return 0;
    }

    public static int checkPdfBytes(String path, String suffix) throws ParameterInvalidException, ParameterOutRangeException {
        String result = "0";
        if (path == null || path.trim().length() == 0) {
            result = "\u8f93\u5165\u6587\u4ef6\u4e0d\u5b58\u5728;      \u9519\u8bef\u7801\u4e3a:700025";
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        if (path.lastIndexOf(".") < 0 || path.toLowerCase().lastIndexOf(suffix) <= 0) {
            result = "\u8f93\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700001";
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        File f = new File(path);
        if (!f.exists()) {
            result = "\u8f93\u5165\u6587\u4ef6\u4e0d\u5b58\u5728;      \u9519\u8bef\u7801\u4e3a:700025";
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        if (f.length() > 0xA00000L) {
            result = "\u8f93\u5165\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa10M\u9650\u5236;      \u9519\u8bef\u7801\u4e3a:700003";
            FileUtils.writeLog(result);
            throw new ParameterOutRangeException(result);
        }
        FileUtils.checkPathLength(path);
        return 0;
    }

    public static int checkPdfBytes(byte[] inputFile, String suffix) throws ParameterInvalidException, ParameterOutRangeException {
        String result = "0";
        if (inputFile == null || inputFile.length == 0) {
            result = "\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700018";
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        if ((long)inputFile.length > 0xA00000L) {
            result = "\u8f93\u5165\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa10M\u9650\u5236;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.PDF_TOO_BIG_ERROR_CODE;
            FileUtils.writeLog(result);
            throw new ParameterOutRangeException(result);
        }
        return 0;
    }

    public static int checkSignValue(String signValue) throws ParameterInvalidException {
        String errorMsg = "";
        if (signValue == null || signValue.trim().equals("")) {
            errorMsg = "\u4f60\u7684\u7b7e\u540d\u503c\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700061";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkHtmlBytes(byte[] inputFile) throws ParameterInvalidException, ParameterOutRangeException {
        String result = "0";
        if (inputFile == null || inputFile.length == 0) {
            result = "\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700018";
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        return 0;
    }

    public static int checkPathLength(String filePath) throws ParameterInvalidException, ParameterOutRangeException {
        String result = "0";
        if (filePath == null || filePath.trim().length() == 0) {
            result = "\u6587\u4ef6\u4e0d\u5b58\u5728;      \u9519\u8bef\u7801\u4e3a:700025";
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        if (filePath != null && filePath.length() > 240) {
            result = "\u6587\u4ef6\u8def\u5f84\u8fc7\u957f;      \u9519\u8bef\u7801\u4e3a:700003";
            FileUtils.writeLog(result);
            throw new ParameterOutRangeException(result);
        }
        return 0;
    }

    public static int checkExtInfoLength(String extInfo) throws ParameterOutRangeException {
        String result = "0";
        if (extInfo == null || extInfo.equals("")) {
            return 0;
        }
        if (extInfo != null && extInfo.length() > 2048) {
            result = "\u7b7e\u7ae0\u6269\u5c55\u5185\u5bb9\u8d85\u8fc7\u4e862048\u5b57\u8282\u9650\u5236;      \u9519\u8bef\u7801\u4e3a:700003";
            FileUtils.writeLog(result);
            throw new ParameterOutRangeException(result);
        }
        if (extInfo != null && extInfo.trim().length() != 0) {
            if ((extInfo = extInfo.trim().toUpperCase()).indexOf("SIGNFORMAT") <= 0 || extInfo.indexOf("BODY") <= 0 || extInfo.indexOf("{") < 0 || extInfo.indexOf("}") <= 0) {
                result = "\u7b7e\u7ae0\u63a5\u53e3ExtNote\u683c\u5f0f\u9519\u8bef\u6216\u8005\u5185\u5bb9\u5b57\u6bb5\u4e0d\u5168;      \u9519\u8bef\u7801\u4e3a:700021";
                FileUtils.writeLog(result);
                throw new ParameterOutRangeException(result);
            }
            int length = extInfo.indexOf("SIGNFORMAT");
            if (length > 0) {
                String singFormat = extInfo.substring((length += "SIGNFORMAT".length()) + 2, length + 3);
                int tempLength = 0;
                tempLength = extInfo.lastIndexOf(",") > 0 ? extInfo.indexOf(",") : extInfo.indexOf("}");
                if (singFormat != null && (!singFormat.equals("0") && !singFormat.equals("1") || tempLength - (length + 4) != 0)) {
                    result = "\u7b7e\u7ae0\u63a5\u53e3ExtNote\u683c\u5f0fSignFormat\u9519\u8bef(\u5e94\u8be50\u62161);      \u9519\u8bef\u7801\u4e3a:700021";
                    FileUtils.writeLog(result);
                    throw new ParameterOutRangeException(result);
                }
            }
        }
        return 0;
    }

    public static int fileExists(byte[] fileName, long size) throws ParameterInvalidException, ParameterOutRangeException {
        String result = "";
        if (fileName == null || fileName.length == 0) {
            result = "\u7b7e\u7ae0\u56fe\u7247\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.IMAGE_IS_NULL_ERROR_CODE;
            FileUtils.writeLog(result);
            throw new ParameterInvalidException(result);
        }
        if ((long)fileName.length > size) {
            result = "\u8d85\u51fa\u56fe\u7247\u6587\u4ef6\u5927\u5c0f\u8303\u56f4" + size + "\u5b57\u8282\u8303\u56f4;      \u9519\u8bef\u7801\u4e3a:" + 700009;
            FileUtils.writeLog(result);
            throw new ParameterOutRangeException(result);
        }
        return 0;
    }

    public static int writeFile(byte[] bContent, String filePath) throws ParameterInvalidException {
        int result = 1;
        FilterOutputStream bouts = null;
        try {
            try {
                String path2;
                File dir2;
                String path1;
                File dir1;
                int index1 = filePath.lastIndexOf("/");
                int index2 = filePath.lastIndexOf("\\");
                if (index1 != -1 && !(dir1 = new File(path1 = filePath.substring(0, index1))).exists()) {
                    dir1.mkdir();
                }
                if (index2 != -1 && !(dir2 = new File(path2 = filePath.substring(0, index2))).exists()) {
                    dir2.mkdir();
                }
                bouts = new BufferedOutputStream(new FileOutputStream(filePath), 1024);
                bouts.write(bContent);
                result = 0;
            }
            catch (Exception e) {
                FileUtils.writeLog("\u751f\u6210\u8f93\u51fa\u6587\u4ef6\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:" + e.getMessage());
                throw new ParameterInvalidException("\u751f\u6210\u8f93\u51fa\u6587\u4ef6\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:" + e.getMessage());
            }
        }
        finally {
            try {
                if (bouts != null) {
                    bouts.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static byte[] readFile(String file_path) throws ParameterInvalidException {
        BufferedInputStream bins = null;
        byte[] bfile = null;
        String path = file_path;
        try {
            try {
                bins = new BufferedInputStream(new FileInputStream(path), 1024);
                if (bins.available() > 0) {
                    bfile = new byte[bins.available()];
                    bins.read(bfile);
                }
            }
            catch (Exception e) {
                FileUtils.writeLog("\u8bfb\u53d6\u5f85\u8f93\u5165\u6587\u4ef6\u9519\u8bef!" + e.getMessage() + 700025);
                throw new ParameterInvalidException("\u8bfb\u53d6\u5f85\u8f93\u5165\u6587\u4ef6\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:" + e.getMessage() + "," + 700025);
            }
        }
        finally {
            try {
                if (bins != null) {
                    bins.close();
                }
            }
            catch (Exception e) {
                FileUtils.writeLog("\u5173\u95ed\u6d41\u5f02\u5e38!" + e.getMessage());
            }
        }
        return bfile;
    }

    public static void writeLog(String message) {
        LoggerUtil.client_error((String)message);
    }

    public static int checkXYZPara(String appName, int visiable, int signAlpha, int signPage, float signPosL, float signPosB, float signPosR, float signPosT) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (appName == null || appName.trim().equals("")) {
            errorMsg = "\u8bc1\u4e66\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u60a8\u5f85\u7b7e\u7ae0\u7684\u8bc1\u4e66\u6807\u8bc6;      \u9519\u8bef\u7801\u4e3a:700013";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (visiable < 0 || visiable > 3) {
            errorMsg = "\u7b7e\u7ae0\u5c5e\u6027\u503c\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff080-3\uff09;      \u9519\u8bef\u7801\u4e3a:700010";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPage < -1000 || signPage > 1000) {
            errorMsg = "\u7b7e\u7ae0\u9875\u7801\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-1000\u81f31000\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700002";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signAlpha < 0 || signAlpha > 100) {
            errorMsg = "\u900f\u660e\u5ea6\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff080-100\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700022";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosL >= signPosR) {
            errorMsg = "\u7b7e\u7ae0\u5de6\u5750\u6807signPosL\u8981\u5c0f\u4e8e\u53f3\u5750\u6807signPosR;      \u9519\u8bef\u7801\u4e3a:700023";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosB >= signPosT) {
            errorMsg = "\u7b7e\u7ae0\u4e0b\u5750\u6807signPosB\u8981\u5c0f\u4e8e\u4e0a\u5750\u6807signPosT;      \u9519\u8bef\u7801\u4e3a:700024";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosR - signPosL < 0.0f || signPosR - signPosL > 350.0f) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u7684\u5bbd\u7684\u8303\u56f4\u8303\u56f4\u5728\uff080.0 ~ 350.0\uff09;      \u9519\u8bef\u7801\u4e3a:700037";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosT - signPosB < 0.0f || signPosT - signPosB > 350.0f) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u7684\u9ad8\u7684\u8303\u56f4\u8303\u56f4\u5728\uff080.0 ~ 350.0\uff09;      \u9519\u8bef\u7801\u4e3a:700037";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosL < 0.0f || signPosL > 594.0f) {
            errorMsg = "\u7b7e\u7ae0\u5de6\u5750\u6807signPosL\u7684\u8303\u56f4\u5728\uff080 ~ 594\uff09;      \u9519\u8bef\u7801\u4e3a:700003";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosR < 0.0f || signPosR > 594.0f) {
            errorMsg = "\u7b7e\u7ae0\u53f3\u5750\u6807signPosR\u7684\u8303\u56f4\u5728\uff080 ~ 594\uff09;      \u9519\u8bef\u7801\u4e3a:700003";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosB < 0.0f || signPosB > 840.0f) {
            errorMsg = "\u7b7e\u7ae0\u4e0b\u5750\u6807signPosB\u7684\u8303\u56f4\u5728\uff080 ~ 840\uff09;      \u9519\u8bef\u7801\u4e3a:700003";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosT < 0.0f || signPosT > 840.0f) {
            errorMsg = "\u7b7e\u7ae0\u4e0a\u5750\u6807signPosT\u7684\u8303\u56f4\u5728\uff080 ~ 840\uff09;      \u9519\u8bef\u7801\u4e3a:700003";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        return 0;
    }

    public static String getLocalIP() {
        if (!localIP.equals("127.0.0.1")) {
            return localIP;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            localIP = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return localIP;
    }

    public static int checkpublicKey(String base64Cert) throws ParameterInvalidException {
        String errorMsg = "";
        if (base64Cert == null || base64Cert.toString() == "") {
            errorMsg = "\u8bc1\u4e66\u516c\u94a5\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700027";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        try {
            EncUtils.getSerKeyByDC(FastBase64.decode(base64Cert));
        }
        catch (Exception e) {
            errorMsg = "\u8bc1\u4e66\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8bc1\u4e66;      \u9519\u8bef\u7801\u4e3a:700020";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkKeyword(String keyword) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (keyword == null || keyword.trim().length() == 0) {
            errorMsg = "\u641c\u7d22\u7684\u5173\u952e\u5b57\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.KEYWORD_IS_NULL_ERROR_CODE;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (keyword.trim().getBytes().length > 64) {
            errorMsg = "\u641c\u7d22\u7684\u5173\u952e\u5b57\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc764\u5b57\u8282\u9650\u5236;      \u9519\u8bef\u7801\u4e3a:700017";
            FileUtils.writeLog(errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        return 0;
    }

    public static int checkType(int type) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (1 != type && 2 != type) {
            errorMsg = "\u9700\u8981\u8f6c\u6362\u7c7b\u578b\u9519\u8bef,\u4ec5\u652f\u63011\u548c2;      \u9519\u8bef\u7801\u4e3a:700032";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkUNameText(String text) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (text == null || text.trim().length() == 0) {
            errorMsg = "\u4e2a\u4eba\u540d\u79f0\u56fe\u7247\u5185\u5bb9\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.TEXT_IS_NULL_ERROR_CODE;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (text.contains(" ")) {
            errorMsg = "\u56fe\u7247\u5185\u5bb9\u5305\u542b\u7a7a\u683c\uff0c\u76ee\u524d\u4e0d\u652f\u6301;      \u9519\u8bef\u7801\u4e3a:700084";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (text.length() < PDFConstant.SEAL_TYPE_SIZE_MIN || text.length() > PDFConstant.SEAL_TEXT_SIZE_MAX) {
            errorMsg = "\u4e2a\u4eba\u540d\u79f0\u56fe\u7247\u957f\u5ea6\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff082 \u81f3 20\u5b57\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkSealText(String text) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (text == null || text.trim().length() == 0) {
            errorMsg = "\u516c\u53f8\u540d\u56fe\u7247\u5185\u5bb9\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700083";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (text.contains(" ")) {
            errorMsg = "\u56fe\u7247\u5185\u5bb9\u5305\u542b\u7a7a\u683c\uff0c\u76ee\u524d\u4e0d\u652f\u6301;      \u9519\u8bef\u7801\u4e3a:700084";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (text.length() < PDFConstant.SEAL_TEXT_SIZE_MIN || text.length() > PDFConstant.SEAL_TEXT_SIZE_MAX) {
            errorMsg = "\u516c\u53f8\u540d\u56fe\u7247\u5185\u5bb9\u957f\u5ea6\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff085 \u81f3 20\u5b57\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkImageType(String imageType) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if ("".equals(imageType.trim()) || imageType.isEmpty()) {
            errorMsg = "\u56fe\u7247\u7c7b\u578b\u4e3a\u7a7a,\u76ee\u524d\u652f\u6301png,gif;      \u9519\u8bef\u7801\u4e3a:700081";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        HashSet<String> imageTypes = new HashSet<String>(){
            {
                this.add("GIF");
                this.add("PNG");
                this.add("png");
                this.add("gif");
            }
        };
        if (imageTypes.add(imageType)) {
            imageTypes.remove(imageType);
            errorMsg = "\u56fe\u7247\u7c7b\u578b\u9519\u8bef,\u4ec5\u652f\u6301png,gif;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkUNamePara(int fontSize, String fontFamily, String fontColor, String isBold) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        HashSet<String> fontFamilys = new HashSet<String>(){
            {
                this.add("SIMSUN");
                this.add("simsun");
            }
        };
        HashSet<String> fontColors = new HashSet<String>(){
            {
                this.add("RED");
                this.add("BLACK");
                this.add("black");
                this.add("red");
            }
        };
        HashSet<String> isBolds = new HashSet<String>(){
            {
                this.add("TRUE");
                this.add("FALSE");
                this.add("true");
                this.add("false");
            }
        };
        if (fontSize == 0) {
            fontSize = 25;
        }
        if (fontSize < PDFConstant.UNAME_TEXT_SIZE_MIN || fontSize > PDFConstant.UNAME_TEXT_SIZE_MAX) {
            errorMsg = "\u56fe\u7247\u8f6c\u6362\u5b57\u4f53\u5c3a\u5bf8\u8303\u56f4\u572820px~50px,errcode:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (fontFamily == null || "".equals(fontFamily.trim())) {
            fontFamily = "SIMSUN";
        }
        if (fontFamilys.add(fontFamily)) {
            fontFamilys.remove(fontFamily);
            errorMsg = "\u5b57\u4f53\u7c7b\u578b\u9519\u8bef,\u4ec5\u652f\u6301SIMSUN(\u5b8b\u4f53)\u548cKAITI(\u6977\u4f53);      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (fontColor == null || "".equals(fontColor.trim())) {
            fontColor = "RED";
        }
        if (fontColors.add(fontColor)) {
            fontColors.remove(fontColor);
            errorMsg = "\u5b57\u4f53\u989c\u8272\u9519\u8bef,\u4ec5\u652f\u6301RED,BLACK;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (isBold == null || "".equals(isBold.trim())) {
            isBold = "FALSE";
        }
        if (isBolds.add(isBold)) {
            isBolds.remove(isBold);
            errorMsg = "isBold\u9519\u8bef,\u4ec5\u652f\u6301true,false;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkSealPara(int sealWidth, String sealType, int sealCenter) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (sealWidth == 0) {
            sealWidth = 225;
        }
        if (sealWidth < PDFConstant.SEAL_SIZE_MIN || sealWidth > PDFConstant.SEAL_SIZE_MAX) {
            errorMsg = "\u516c\u53f8\u7528\u7ae0\u5c3a\u5bf8\u8303\u56f4\u9519\u8bef,\u53ef\u9009\u8303\u56f4100 ~ 500;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (sealCenter != 0 && 1 != sealCenter) {
            errorMsg = "sealCenter\u9009\u62e9\u9519\u8bef,\u4ec5\u652f\u6301 0 ,1;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (sealType == null || "".equals(sealType.trim()) || sealType.length() < PDFConstant.SEAL_TYPE_SIZE_MIN || sealType.length() > PDFConstant.SEAL_TYPE_SIZE_MAX) {
            errorMsg = "\u516c\u7ae0\u7c7b\u578b\u540d\u79f0\uff0c\u5b57\u6570\u8303\u56f4\u8981\u6c42\u8303\u56f42~8;      \u9519\u8bef\u7801\u4e3a:" + PDFConstant.UNAME_AGRE_ERROR;
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkAppName(String appName) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (appName == null || appName.trim().equals("")) {
            errorMsg = "\u8bc1\u4e66\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u60a8\u5f85\u7b7e\u7ae0\u7684\u8bc1\u4e66\u6807\u8bc6;      \u9519\u8bef\u7801\u4e3a:700013";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkKWXYPara(int visiable, int signAlpha, int kwIndex, int pos, boolean hasPos, float offset, float xoffset, float yoffset, float imageWidth, float imageHeight) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (visiable < 0 || visiable > 3) {
            errorMsg = "\u7b7e\u7ae0\u5c5e\u6027\u503c\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff080-3\uff09;      \u9519\u8bef\u7801\u4e3a:700010";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (kwIndex < -32 || kwIndex > 32) {
            errorMsg = "\u5173\u952e\u5b57\u5e8f\u53f7\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-32\u81f332\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700031";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signAlpha < 0 || signAlpha > 100) {
            errorMsg = "\u900f\u660e\u5ea6\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff080-100\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700022";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (imageWidth < 0.0f || imageWidth > 350.0f) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u7684\u5bbd\u7684\u8303\u56f4\u8303\u56f4\u5728\uff080.0 ~ 350.0\uff09;      \u9519\u8bef\u7801\u4e3a:700037";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (imageHeight < 0.0f || imageHeight > 350.0f) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u7684\u9ad8\u7684\u8303\u56f4\u8303\u56f4\u5728\uff080.0 ~ 350.0\uff09;      \u9519\u8bef\u7801\u4e3a:700037";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (!hasPos) {
            if (xoffset < -500.0f || xoffset > 500.0f) {
                errorMsg = "\u7b7e\u7ae0\u56fe\u7247X\u504f\u79fb\u91cf\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-500\u81f3500\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700011";
                LoggerUtil.client_error((String)errorMsg);
                throw new ParameterOutRangeException(errorMsg);
            }
            if (yoffset < -500.0f || yoffset > 500.0f) {
                errorMsg = "\u7b7e\u7ae0\u56fe\u7247Y\u504f\u79fb\u91cf\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-500\u81f3500\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700012";
                LoggerUtil.client_error((String)errorMsg);
                throw new ParameterOutRangeException(errorMsg);
            }
        } else {
            if (pos < 1 || pos > 4) {
                errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u65b9\u4f4d\u8f93\u5165\u9519\u8bef\u5e94\u8be5\u5728\uff081-4\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700011";
                LoggerUtil.client_error((String)errorMsg);
                throw new ParameterOutRangeException(errorMsg);
            }
            if (pos != 1 && (offset < -500.0f || offset > 500.0f)) {
                errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u504f\u79fb\u91cf\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-500\u81f3500\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700012";
                LoggerUtil.client_error((String)errorMsg);
                throw new ParameterOutRangeException(errorMsg);
            }
        }
        return 0;
    }

    public static int checkXYZPara_NoAppName(int visiable, int signAlpha, int signPage, float signPosL, float signPosB, float signPosR, float signPosT) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (visiable < 0 || visiable > 3) {
            errorMsg = "\u7b7e\u7ae0\u5c5e\u6027\u503c\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff080-3\uff09;      \u9519\u8bef\u7801\u4e3a:700010";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPage < -1000 || signPage > 1000) {
            errorMsg = "\u7b7e\u7ae0\u9875\u7801\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-1000\u81f31000\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700002";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signAlpha < 0 || signAlpha > 100) {
            errorMsg = "\u900f\u660e\u5ea6\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff080-100\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700022";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosL >= signPosR) {
            errorMsg = "\u7b7e\u7ae0\u5de6\u5750\u6807signPosL\u8981\u5c0f\u4e8e\u53f3\u5750\u6807signPosR;      \u9519\u8bef\u7801\u4e3a:700023";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosB >= signPosT) {
            errorMsg = "\u7b7e\u7ae0\u4e0b\u5750\u6807signPosB\u8981\u5c0f\u4e8e\u4e0a\u5750\u6807signPosT;      \u9519\u8bef\u7801\u4e3a:700024";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosR - signPosL < 0.0f || signPosR - signPosL > 350.0f) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u7684\u5bbd\u7684\u8303\u56f4\u8303\u56f4\u5728\uff080.0 ~ 350.0\uff09;      \u9519\u8bef\u7801\u4e3a:700037";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (signPosT - signPosB < 0.0f || signPosT - signPosB > 350.0f) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u7684\u9ad8\u7684\u8303\u56f4\u8303\u56f4\u5728\uff080.0 ~ 350.0\uff09;      \u9519\u8bef\u7801\u4e3a:700037";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        return 0;
    }

    public static int checkKWXYPara(int index, int pos, int offset) throws ParameterInvalidException, ParameterOutRangeException {
        String errorMsg = "";
        if (index < -32 || index > 32) {
            errorMsg = "\u5173\u952e\u5b57\u5e8f\u53f7\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-32\u81f332\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700031";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (pos < 1 || pos > 4) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u65b9\u4f4d\u8f93\u5165\u9519\u8bef\u5e94\u8be5\u5728\uff081-4\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700011";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        if (offset < -500 || offset > 500) {
            errorMsg = "\u7b7e\u7ae0\u56fe\u7247\u504f\u79fb\u91cf\u8f93\u5165\u8303\u56f4\u9519\u8bef\u5e94\u8be5\u5728\uff08-500\u81f3500\uff09\u5185;      \u9519\u8bef\u7801\u4e3a:700012";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterOutRangeException(errorMsg);
        }
        return 0;
    }

    public static int checkDataPara(String sessionKey, String signReq, String signReqDig) throws ParameterInvalidException {
        String errorMsg = "";
        if (sessionKey == null || "".equals(sessionKey.trim())) {
            errorMsg = "\u8bf7\u6c42\u52a0\u5bc6\u5305\u4e2dsessionKey\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700033";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (signReq == null || "".equals(signReq.trim())) {
            errorMsg = "\u8bf7\u6c42\u52a0\u5bc6\u5305\u4e2d\u5f85\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700034";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (signReqDig == null || "".equals(signReqDig.trim())) {
            errorMsg = "\u8bf7\u6c42\u52a0\u5bc6\u5305\u4e2dCRC32\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700035";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkSignDataPara(String originalData) throws ParameterInvalidException {
        String errorMsg = "";
        if (originalData == null || "".equals(originalData.trim())) {
            errorMsg = "\u6570\u636e\u7b7e\u540d\u539f\u6587\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700050";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkHashSignData(String hashData) throws ParameterInvalidException {
        String errorMsg = "";
        if (hashData == null || "".equals(hashData.trim())) {
            errorMsg = "Hash\u503c\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700050";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (hashData.trim().length() != 40 && hashData.trim().length() != 64) {
            errorMsg = "Hash\u503c\u957f\u5ea6\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700066";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkVerfySignPara(int includePlainData, int certType, int tsCertType) throws ParameterInvalidException {
        String errorMsg = "";
        if (includePlainData != 0 && includePlainData != 1) {
            errorMsg = "plainData\u8f93\u51fa\u9519\u8bef\uff0c\u4ec5\u652f\u6301 0 , 1;      \u9519\u8bef\u7801\u4e3a:700040";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (certType != 0 && certType != 1) {
            errorMsg = "certContent\u8f93\u51fa\u9519\u8bef\uff0c\u4ec5\u652f\u6301 0 , 1;      \u9519\u8bef\u7801\u4e3a:700041";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (tsCertType != 0 && tsCertType != 1) {
            errorMsg = "tsCertContent\u8f93\u51fa\u9519\u8bef\uff0c\u4ec5\u652f\u6301 0 , 1;      \u9519\u8bef\u7801\u4e3a:700042";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static void checkSignatureAnnotationParams(String signatureAnnotation, String signatureNumber, String annotationPage) throws ParameterInvalidException {
        String errorMsg = "";
        if (signatureAnnotation != null && !"".equals(signatureAnnotation) && (signatureNumber == null || "".equals(signatureNumber.trim()) || annotationPage == null || "".equals(annotationPage.trim()))) {
            errorMsg = "signatureAnnotation\u53c2\u6570\u503c\u4e0d\u4e3anull\u6216\u7a7a\u65f6\uff0csignatureNumber\u53c2\u6570\u548cannotationPage\u53c2\u6570\u4e3a\u5fc5\u4f20\u53c2\u6570;";
            throw new ParameterInvalidException(errorMsg);
        }
        if (signatureNumber != null && !"".equals(signatureNumber)) {
            try {
                Integer.parseInt(signatureNumber);
            }
            catch (Exception e) {
                e.printStackTrace();
                errorMsg = "signatureNumber\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u53c2\u6570\u503c\u7684\u5185\u5bb9\u987b\u4e3a\u6570\u5b57\u6216\u6570\u5b57\u7684\u5b57\u7b26\u4e32\u7c7b\u578b;";
                throw new ParameterInvalidException(errorMsg);
            }
        }
        if (annotationPage != null && !"".equals(annotationPage)) {
            try {
                Integer.parseInt(annotationPage);
            }
            catch (Exception e) {
                e.printStackTrace();
                errorMsg = "annotationPage\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\uff0c\u53c2\u6570\u503c\u7684\u5185\u5bb9\u987b\u4e3a\u6570\u5b57\u6216\u6570\u5b57\u7684\u5b57\u7b26\u4e32\u7c7b\u578b;";
                throw new ParameterInvalidException(errorMsg);
            }
        }
    }

    public static int checkSignData(String originalData1, String originalData2) throws ParameterInvalidException {
        String errorMsg = "";
        if (originalData1 == null && "".equals(originalData2)) {
            errorMsg = "\u9a8c\u8bc1\u6570\u636e\u7b7e\u540d\u539f\u6587\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u539f\u6587;      \u9519\u8bef\u7801\u4e3a:700043";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (originalData2 == null && "".equals(originalData1)) {
            errorMsg = "\u9a8c\u8bc1\u6570\u636e\u7b7e\u540d\u539f\u6587\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u539f\u6587;      \u9519\u8bef\u7801\u4e3a:700043";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (originalData1 == null && originalData2 == null) {
            errorMsg = "\u9a8c\u8bc1\u6570\u636e\u7b7e\u540d\u539f\u6587\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u539f\u6587;      \u9519\u8bef\u7801\u4e3a:700043";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if ("".equals(originalData1) && "".equals(originalData2)) {
            errorMsg = "\u9a8c\u8bc1\u6570\u636e\u7b7e\u540d\u539f\u6587\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u539f\u6587;      \u9519\u8bef\u7801\u4e3a:700043";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static int checkGenCert(String certAlg, String p10, String appKey) throws ParameterInvalidException {
        String errorMsg = "";
        HashSet<String> certAlgTypes = new HashSet<String>(){
            {
                this.add("RSA");
                this.add("SM2");
                this.add("ECC");
            }
        };
        if (certAlgTypes.add(certAlg.toUpperCase())) {
            certAlgTypes.remove(certAlg);
            errorMsg = "\u8bc1\u4e66\u7b97\u6cd5\u540d\u79f0\u9519\u8bef,\u4ec5\u652f\u6301RSA,SM2;      \u9519\u8bef\u7801\u4e3a:700044";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (p10 == null || "".equals(p10.trim())) {
            errorMsg = "\u79c1\u94a5\u5bc6\u7801\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u7684\u79c1\u94a5\u5bc6\u7801;      \u9519\u8bef\u7801\u4e3a:700047";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (appKey == null || "".equals(appKey.trim())) {
            errorMsg = "\u5546\u6237\u53f7\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u5546\u6237\u53f7;      \u9519\u8bef\u7801\u4e3a:700049";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (appKey != null && appKey.length() != 16) {
            errorMsg = "\u5546\u6237\u53f7\u957f\u5ea6\u9519\u8bef;      \u9519\u8bef\u7801\u4e3a:700073";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }

    public static void checkGenP10(String certAlg, int pubKeyLength, String userName, String pwd) throws ParameterInvalidException {
        String errorMsg = "";
        HashSet<String> certAlgTypes = new HashSet<String>(){
            {
                this.add("RSA");
                this.add("SM2");
                this.add("ECC");
            }
        };
        if (certAlgTypes.add(certAlg.toUpperCase())) {
            certAlgTypes.remove(certAlg);
            errorMsg = "\u8bc1\u4e66\u7b97\u6cd5\u540d\u79f0\u9519\u8bef,\u4ec5\u652f\u6301RSA,SM2;      \u9519\u8bef\u7801\u4e3a:700044";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if ("RSA".equals(certAlg.toUpperCase()) && pubKeyLength != 1024 && pubKeyLength != 2048) {
            errorMsg = "\u516c\u94a5\u957f\u5ea6\u9519\u8bef\uff0cRSA\u65f6\u516c\u94a5\u957f\u5ea6\u987b\u4e3a1024\u62162048;       \u9519\u8bef\u7801\u4e3a:700045";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (userName == null || "".equals(userName.trim())) {
            errorMsg = "\u7528\u6237\u540d\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7528\u6237\u540d;      \u9519\u8bef\u7801\u4e3a:700046";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        FileUtils.checkPwd(pwd);
    }

    public static void checkeUserInfo(String priKey, String cert, String pwd) throws ParameterInvalidException {
        FileUtils.checkPriKey(priKey);
        if (cert == null || "".equals(cert.trim())) {
            String errorMsg = "\u6570\u636e\u7b7e\u540d\u8bc1\u4e66\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u7684\u6b63\u786e\u7684\u8bc1\u4e66;      \u9519\u8bef\u7801\u4e3a:700020";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        FileUtils.checkPwd(pwd);
    }

    public static void checkPriKey(String priKey) throws ParameterInvalidException {
        if (priKey == null || "".equals(priKey.trim())) {
            String errorMsg = "\u6570\u636e\u7b7e\u540d\u79c1\u94a5\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u7684\u6b63\u786e\u7684\u79c1\u94a5;      \u9519\u8bef\u7801\u4e3a:700060";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
    }

    public static void checkPwd(String pwd) throws ParameterInvalidException {
        if (pwd == null || "".equals(pwd.trim())) {
            String errorMsg = "\u79c1\u94a5\u5bc6\u7801\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u7684\u79c1\u94a5\u5bc6\u7801;      \u9519\u8bef\u7801\u4e3a:700047";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (!pwd.matches("^[a-zA-Z0-9,\uff0c\u3001_@/]{6,32}$")) {
            String errorMsg = "\u79c1\u94a5\u5bc6\u7801\u53ea\u80fd\u4e3a\uff08\u6570\u5b57 \u5b57\u6bcd \u4e0b\u5212\u7ebf @ \u3001 / \uff0c , \uff09\u4e14\u957f\u5ea6\u4e3a6-32\u4f4d;      \u9519\u8bef\u7801\u4e3a:700048";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
    }

    public static void checkPackSignData(String OriginalData2, String channel, List<String> userSigns) throws ParameterInvalidException, ParseException {
        if (OriginalData2 == null || "".equals(OriginalData2)) {
            String errorMsg = "\u6570\u636e\u7b7e\u540d\u539f\u6587\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u7684\u7b7e\u540d\u6570\u636e;      \u9519\u8bef\u7801\u4e3a:700050";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        try {
            FastBase64.decode(OriginalData2);
        }
        catch (Exception e) {
            String errorMsg = "\u6570\u636e\u7b7e\u540d\u539f\u6587\u7c7b\u578b\u9519\u8bef,\u8bf7\u8f93\u5165\u7684Base64\u7f16\u7801\u539f\u6587;      \u9519\u8bef\u7801\u4e3a:700050";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (channel == null || "".equals(channel.trim())) {
            String errorMsg = "\u6e20\u9053\u53f7\u4e0d\u5b58\u5728,\u8bf7\u8f93\u5165\u7684 \u6b63\u786e\u7684\u6e20\u9053\u53f7;      \u9519\u8bef\u7801\u4e3a:700053";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (userSigns == null || userSigns.size() == 0) {
            String errorMsg = "\u6700\u5c11\u8981\u4e0a\u4f20\u4e00\u6761\u7b7e\u540d\u4fe1\u606f;      \u9519\u8bef\u7801\u4e3a:700065";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        int i = 0;
        while (i < userSigns.size()) {
            HashSet<String> credTypes;
            String credNumber = JsonUtils.getStringValue(JsonUtils.getValue(userSigns.get(i), "credNumber"));
            if (credNumber == null || "".equals(credNumber.trim())) {
                String errorMsg = "\u6570\u636e\u7b7e\u540d\u7b7e\u540d\u4eba\u8bc1\u4ef6\u53f7\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u7684\u6b63\u786e\u7684\u8bc1\u4ef6\u53f7;      \u9519\u8bef\u7801\u4e3a:700051";
                FileUtils.writeLog(errorMsg);
                throw new ParameterInvalidException(errorMsg);
            }
            String uName = JsonUtils.getStringValue(JsonUtils.getValue(userSigns.get(i), "uName"));
            if (uName == null || "".equals(uName.trim())) {
                String errorMsg = "\u6570\u636e\u7b7e\u540d\u7b7e\u540d\u4eba\u59d3\u540d\u4e3a\u7a7a,\u8bf7\u8f93\u5165\u7684\u6b63\u786e\u7684\u7b7e\u540d\u4eba\u59d3\u540d;      \u9519\u8bef\u7801\u4e3a:700052";
                FileUtils.writeLog(errorMsg);
                throw new ParameterInvalidException(errorMsg);
            }
            String credType = JsonUtils.getStringValue(JsonUtils.getValue(userSigns.get(i), "credType"));
            if (credType == null || "".equals(credType.trim())) {
                credType = "1";
            }
            if ((credTypes = new HashSet<String>(){
                {
                    this.add("1");
                    this.add("2");
                    this.add("3");
                    this.add("4");
                }
            }).add(credType)) {
                credTypes.remove(credType);
                String errorMsg = "\u8bc1\u4ef6\u7c7b\u578b\u9519\u8bef\u3002\u73b0\u4ec5\u652f\u6301\u8eab\u4efd\u8bc1\u3001\u519b\u5b98\u8bc1\u3001\u62a4\u7167\u3001\u6237\u53e3\u672c;      \u9519\u8bef\u7801\u4e3a:700056";
                LoggerUtil.client_error((String)errorMsg);
                throw new ParameterInvalidException(errorMsg);
            }
            String image = JsonUtils.getStringValue(JsonUtils.getValue(userSigns.get(i), "image"));
            String fPImage = JsonUtils.getStringValue(JsonUtils.getValue(userSigns.get(i), "fPImage"));
            if (image == null && "".equals(fPImage.trim()) || fPImage == null && "".equals(image.trim()) || image == null && fPImage == null || "".equals(image.trim()) && "".equals(fPImage.trim())) {
                String errorMsg = "\u8bf7\u4fdd\u6301\u81f3\u5c11\u4e00\u79cd\u56fe\u7247\u624b\u5199\u6216\u6307\u7eb9\u56fe\u7247\u4fe1\u606f,\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u56fe\u7247\u4fe1\u606f;      \u9519\u8bef\u7801\u4e3a:700054";
                LoggerUtil.client_error((String)errorMsg);
                throw new ParameterInvalidException(errorMsg);
            }
            String format = JsonUtils.getStringValue(JsonUtils.getValue(userSigns.get(i), "format"));
            String fPFormat = JsonUtils.getStringValue(JsonUtils.getValue(userSigns.get(i), "fPFormat"));
            HashSet<String> formats = new HashSet<String>(){
                {
                    this.add("image/gif");
                    this.add("image/jpeg");
                }
            };
            if (image != null && !"".equals(image)) {
                if (format == null || "".equals(format.trim())) {
                    String errorMsg = "\u624b\u5199\u56fe\u7247\u7c7b\u578b\u9519\u8bef,\u73b0\u4ec5\u652f\u6301 image/gif\u3001image/jpeg\u4e24\u79cd\u683c\u5f0f ;      \u9519\u8bef\u7801\u4e3a:700055";
                    FileUtils.writeLog(errorMsg);
                    throw new ParameterInvalidException(errorMsg);
                }
                if (formats.add(format)) {
                    formats.remove(format);
                    String errorMsg = "\u624b\u5199\u56fe\u7247\u7c7b\u578b\u9519\u8bef,\u73b0\u4ec5\u652f\u6301 image/gif\u3001image/jpeg\u4e24\u79cd\u683c\u5f0f ;      \u9519\u8bef\u7801\u4e3a:700055";
                    FileUtils.writeLog(errorMsg);
                    throw new ParameterInvalidException(errorMsg);
                }
            }
            if (fPImage != null && !"".equals(fPImage)) {
                if (fPFormat == null || "".equals(fPFormat.trim())) {
                    String errorMsg = "\u624b\u5199\u56fe\u7247\u7c7b\u578b\u9519\u8bef,\u73b0\u4ec5\u652f\u6301 image/gif\u3001image/jpeg\u4e24\u79cd\u683c\u5f0f ;      \u9519\u8bef\u7801\u4e3a:700055";
                    FileUtils.writeLog(errorMsg);
                    throw new ParameterInvalidException(errorMsg);
                }
                if (formats.add(fPFormat)) {
                    formats.remove(fPFormat);
                    String errorMsg = "\u6307\u7eb9\u56fe\u7247\u7c7b\u578b\u9519\u8bef,\u73b0\u4ec5\u652f\u6301 image/gif\u3001image/jpeg\u4e24\u79cd\u683c\u5f0f ;      \u9519\u8bef\u7801\u4e3a:700055";
                    FileUtils.writeLog(errorMsg);
                    throw new ParameterInvalidException(errorMsg);
                }
            }
            ++i;
        }
    }

    public static void checkOriginal(byte[] inData) throws ParameterInvalidException {
        if (inData == null || inData.length == 0) {
            String errorMsg = "\u5b58\u8bc1\u63a5\u53e3\u539f\u6587\u4e3a\u7a7a\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7b7e\u540d\u6570\u636e;      \u9519\u8bef\u7801\u4e3a:700050";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
    }

    public static void checkTxId(String txId) throws ParameterInvalidException {
        if (txId == null || "".equals(txId.trim())) {
            String errorMsg = "\u67e5\u8be2\u63a5\u53e3txId\u4e3a\u7a7a\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684txId;      \u9519\u8bef\u7801\u4e3a:700058";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
    }

    public static String checkCertOID(String certOID) throws ParameterInvalidException {
        HashSet<String> jsonKeys = new HashSet<String>();
        jsonKeys.add("SnapshotHash");
        jsonKeys.add("Version");
        jsonKeys.add("IDAuth");
        jsonKeys.add("descript");
        jsonKeys.add("type");
        JSONObject jsonObj = null;
        try {
            jsonObj = (JSONObject)JSONValue.parseWithException((String)certOID);
            Set certOidKeys = jsonObj.keySet();
            for (String certOidKey : certOidKeys) {
                if (!jsonKeys.add(certOidKey)) continue;
                throw new ParameterInvalidException();
            }
            if (JsonUtils.getValue(certOID, "IDAuth") != null) {
                JSONArray idAuths = (JSONArray)JSONValue.parseWithException((String)JsonUtils.getStringValue(JsonUtils.getValue(certOID, "IDAuth")));
                for (Object idAuth : idAuths) {
                    JSONObject idAuthJson = (JSONObject)JSONValue.parseWithException((String)idAuth.toString());
                    Set idAuthKeys = idAuthJson.keySet();
                    for (String idAuthKey : idAuthKeys) {
                        if (!jsonKeys.add(idAuthKey)) continue;
                        throw new ParameterInvalidException();
                    }
                }
            }
            jsonObj.put((Object)"Version", (Object)"1.2");
        }
        catch (Exception e) {
            String errorMsg = "certOID\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684certOID;      \u9519\u8bef\u7801\u4e3a:700057";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return jsonObj.toString();
    }

    public static void checkSignDataHashP7WithUserInfoParams(String hash, String userName, String idNumber, String channelId) throws ParameterInvalidException {
        if (hash == null || "".equals(hash)) {
            String errorMsg = "\u539f\u6587hash\u503c\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700062";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (userName == null || "".equals(userName)) {
            String errorMsg = "\u7528\u6237\u540d\u53c2\u6570\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700052";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (idNumber == null || "".equals(idNumber)) {
            String errorMsg = "\u8eab\u4efd\u8bc1\u53f7\u53c2\u6570\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700063";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        if (channelId == null || "".equals(channelId)) {
            String errorMsg = "\u6e20\u9053\u53f7\u53c2\u6570\u4e3a\u7a7a;      \u9519\u8bef\u7801\u4e3a:700064";
            LoggerUtil.client_error((String)errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
    }

    public static boolean checkFileCanRead(File file) {
        try {
            FileReader fileReader = new FileReader(String.valueOf(file.getAbsolutePath()) + File.separator);
            fileReader.read();
            fileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtils.writeLog("Exception when checking if file could be read with message:" + e.getMessage());
            return false;
        }
        return true;
    }

    public static int cheakSealEinNumber(String sealEinNumber) throws ParameterInvalidException {
        String errorMsg = null;
        if (sealEinNumber != null && sealEinNumber.trim().length() == 15 || sealEinNumber != null && sealEinNumber.trim().length() == 18 || sealEinNumber != null && sealEinNumber.trim().length() == 20) {
            errorMsg = "sealEinNumber\u957f\u5ea6\u9519\u8bef\uff0c\u957f\u5ea6\u4ec5\u652f\u630115,18,20;      \u9519\u8bef\u7801\u4e3a:700088";
            FileUtils.writeLog(errorMsg);
            throw new ParameterInvalidException(errorMsg);
        }
        return 0;
    }
}

