/*
 * Decompiled with CFR 0.152.
 */
package cn.trust.sign.client.utils;

import cn.trust.sign.client.utils.FastBase64;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Random;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncUtils {
    public static String genRandomNum(int pinLen) {
        Random r = new Random();
        byte[] bRan = new byte[pinLen];
        r.nextBytes(bRan);
        return FastBase64.encode(bRan);
    }

    public static byte[] encryptByPublicKey(byte[] data, PublicKey publicKey) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] getECBResult(byte[] mToEncode, byte[] desKey) {
        byte[] data = null;
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(desKey);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cpher.init(1, deskey);
            data = cpher.doFinal(mToEncode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static byte[] decrypt(byte[] data, byte[] desKey) {
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(desKey);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(2, deskey);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final String crcDigestHexStr(byte[] content) {
        CRC32 crc = new CRC32();
        crc.update(content);
        return Long.toHexString(crc.getValue()).toUpperCase();
    }

    public static String getEncKey(byte[] key, PublicKey publicKey) {
        byte[] encKeyByte = null;
        String encKey = null;
        try {
            encKeyByte = EncUtils.encryptByPublicKey(key, publicKey);
            encKey = FastBase64.encode(encKeyByte);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encKey;
    }

    public static String getEncData(String info, byte[] key) throws UnsupportedEncodingException {
        byte[] bytes = info.getBytes("UTF-8");
        byte[] encInfo = EncUtils.getECBResult(bytes, key);
        String encData = FastBase64.encode(encInfo);
        return encData;
    }

    public static PublicKey getSerKeyByDC(byte[] derCert) throws Exception {
        CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bIns = new ByteArrayInputStream(derCert);
        X509Certificate Cert = (X509Certificate)certificatefactory.generateCertificate(bIns);
        return Cert.getPublicKey();
    }

    public static PublicKey getPublicKey(String base64Cert) {
        PublicKey publicKey = null;
        try {
            byte[] cert = FastBase64.decode(base64Cert);
            publicKey = EncUtils.getSerKeyByDC(cert);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return publicKey;
    }
}

