/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.util;

import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpProgressMonitorImpl
implements SftpProgressMonitor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    long transferredBytes = 0L;
    private final File localFile;
    long fileSize;
    LocalDateTime currentDateTime;
    private String remoteHost;

    public SftpProgressMonitorImpl(File localFile, String remoteHost) {
        this.localFile = localFile;
        this.fileSize = localFile.length();
        this.remoteHost = remoteHost;
    }

    public void init(int op, String src, String dest, long max) {
        this.logger.debug("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u3010{}\u3011\u5230\u3010{}\u3011\u670d\u52a1\u5668\uff0c\u5927\u5c0f\u4e3a{}\u5b57\u8282\u3002", new Object[]{this.localFile.getAbsolutePath(), this.remoteHost, this.fileSize});
        this.currentDateTime = LocalDateTime.now();
    }

    public boolean count(long count) {
        this.transferredBytes += count;
        double v = (double)this.transferredBytes * 100.0 / (double)this.fileSize;
        if (v == 100.0) {
            this.logger.debug("\u5df2\u4e0a\u4f20 {}/{} \u5b57\u8282 ({}%)", new Object[]{this.transferredBytes, this.fileSize, v});
        } else {
            int i = LocalDateTime.now().minusSeconds(2L).compareTo(this.currentDateTime);
            if (i > 0) {
                this.currentDateTime = LocalDateTime.now();
                this.logger.debug("\u5df2\u4e0a\u4f20 {}/{} \u5b57\u8282 ({}%)", new Object[]{this.transferredBytes, this.fileSize, v});
            }
        }
        return true;
    }

    public void end() {
        this.logger.debug("\u6587\u4ef6\u3010{}\u3011\u5df2\u7ecf\u4e0a\u4f20\u5230\u3010{}\u3011\u670d\u52a1\u5668", (Object)this.localFile.getAbsolutePath(), (Object)this.remoteHost);
    }
}

