/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.kdgcsoft.javafilesync.bean.FileOpStatus;
import com.kdgcsoft.javafilesync.bean.UploadStatus;
import com.kdgcsoft.javafilesync.util.SftpProgressMonitorImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpFileOperator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Session session;
    private ChannelSftp sftpChannel;
    private final String remoteHost;
    private final String remoteUser;
    private final String remotePassword;
    private boolean isConnect;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public SftpFileOperator(String remoteHost, String remoteUser, String remotePassword) throws JSchException {
        this.remoteHost = remoteHost;
        this.remoteUser = remoteUser;
        this.remotePassword = remotePassword;
        this.doConnect();
        this.executor.scheduleAtFixedRate(() -> {
            this.isConnect = this.canConnect();
            if (this.isConnect) {
                this.logger.debug("\u3010{}\u3011\u8fde\u63a5\u6210\u529f", (Object)remoteHost);
            } else {
                this.logger.debug("\u3010{}\u3011\u8fde\u63a5\u5931\u8d25", (Object)remoteHost);
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public UploadStatus copy(String localFilePath, String destPath) throws SftpException {
        this.doConnect();
        if (this.exists(destPath)) {
            return UploadStatus.FILE_EXIST;
        }
        Path path = Paths.get(destPath, new String[0]);
        Path parent = path.getParent();
        String parentPath = parent.toString().replace("\\", "/");
        this.mkdir(parentPath);
        try {
            this.sftpChannel.put(Files.newInputStream(Paths.get(localFilePath, new String[0]), new OpenOption[0]), destPath, (SftpProgressMonitor)new SftpProgressMonitorImpl(new File(localFilePath), this.remoteHost));
            return UploadStatus.UPLOAD_SUCCESS;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                this.logger.error("\u8fdc\u7a0b\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
            } else {
                if (e.id == 3) {
                    this.logger.error("\u65e0\u6743\u9650\u4e0a\u4f20\u6587\u4ef6\uff01");
                    return UploadStatus.NOT_PERMISSION;
                }
                this.logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getLocalizedMessage());
            }
            e.printStackTrace();
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getLocalizedMessage());
        }
        this.sftpChannel.disconnect();
        this.session.disconnect();
        return UploadStatus.UPLOAD_FAILED;
    }

    public void deleteDir(String remoteFilePath) throws JSchException, SftpException {
        this.doConnect();
        try {
            if (this.exists(remoteFilePath)) {
                this.sftpChannel.rmdir(remoteFilePath);
            }
        }
        catch (SftpException e) {
            this.logger.error("\u8fdc\u7a0b\u6587\u4ef6\u76ee\u5f55\u3010{}\u3011\u3010{}\u3011\u5220\u9664\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\u4e3a\uff1a{}", new Object[]{this.remoteHost, remoteFilePath, e.getLocalizedMessage()});
            throw e;
        }
    }

    public void delete(String remoteFilePath) throws JSchException, SftpException {
        this.doConnect();
        try {
            if (this.exists(remoteFilePath)) {
                this.sftpChannel.rm(remoteFilePath);
            }
        }
        catch (SftpException e) {
            this.logger.error("\u8fdc\u7a0b\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u5220\u9664\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0\u4e3a\uff1a{}", new Object[]{this.remoteHost, remoteFilePath, e.getLocalizedMessage()});
        }
    }

    public void rename(String remoteFilePath, String newName) {
        this.doConnect();
        this.logger.debug("\u5f00\u59cb\u91cd\u547d\u540d\u8fdc\u7a0b\u6587\u4ef6\u3010{}\u3011", (Object)remoteFilePath);
        try {
            this.sftpChannel.rename(remoteFilePath, newName);
        }
        catch (SftpException e) {
            this.logger.error("\u8fdc\u7a0b\u6587\u4ef6\u3010{}\u3011\u91cd\u547d\u540d\u4ea7\u751f\u5f02\u5e38\uff0c\u5177\u4f53\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a{}", (Object)remoteFilePath, (Object)e.getLocalizedMessage());
        }
    }

    public FileOpStatus mkdir(String remoteDirPath) throws SftpException {
        this.doConnect();
        if (!this.exists(remoteDirPath)) {
            block5: {
                try {
                    this.sftpChannel.mkdir(remoteDirPath);
                }
                catch (SftpException e) {
                    if (e.id == 2) {
                        FileOpStatus mkdir = this.mkdir(Paths.get(remoteDirPath, new String[0]).getParent().toString().replace("\\", "/"));
                        if (FileOpStatus.SUCCESS == mkdir) {
                            this.mkdir(remoteDirPath);
                        }
                        this.logger.error("\u521b\u5efa\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u5931\u8d25", (Object)this.remoteHost, (Object)remoteDirPath);
                        e.printStackTrace();
                        return FileOpStatus.UNKNOWN;
                    }
                    if (e.id != 3) break block5;
                    this.logger.error("\u6ca1\u6709\u3010{}\u3011\u3010{}\u3011\u521b\u5efa\u76ee\u5f55\u7684\u6743\u9650", (Object)this.remoteHost, (Object)remoteDirPath);
                    return FileOpStatus.NO_PERMISSION;
                }
            }
            return FileOpStatus.SUCCESS;
        }
        return FileOpStatus.SUCCESS;
    }

    public boolean exists(String remotePath) throws SftpException {
        SftpATTRS attrs;
        try {
            this.doConnect();
            attrs = this.sftpChannel.stat(remotePath);
            if (attrs != null) {
                this.logger.debug("\u5df2\u7ecf\u5b58\u5728\u8fdc\u7a0b\u8def\u5f84\u3010{}\u3011", (Object)remotePath);
            } else {
                this.logger.debug("\u8fdc\u7a0b\u8def\u5f84\u3010{}\u3011\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u8fdb\u884c\u521b\u5efa", (Object)remotePath);
            }
        }
        catch (SftpException e) {
            if (e.id == 2) {
                this.logger.debug("\u8fdc\u7a0b\u6587\u4ef6\u3010{}\u3011\u8def\u5f84\u4e0d\u5b58\u5728", (Object)remotePath);
                return false;
            }
            this.logger.error("\u5224\u65ad\u6587\u4ef6\u3010{}\u3011\u8def\u5f84\u662f\u5426\u5b58\u5728\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a{}", (Object)remotePath, (Object)e.getLocalizedMessage());
            throw e;
        }
        return attrs != null;
    }

    public synchronized void doConnect() {
        if (this.sftpChannel == null || this.sftpChannel.isClosed()) {
            if (this.session != null && this.session.isConnected()) {
                this.session.disconnect();
            }
            try {
                JSch jsch = new JSch();
                Session session = jsch.getSession(this.remoteUser, this.remoteHost);
                session.setPassword(this.remotePassword);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect(5000);
                ChannelSftp sftpChannel = (ChannelSftp)session.openChannel("sftp");
                int timeout = 5000;
                sftpChannel.connect(timeout);
                this.session = session;
                this.sftpChannel = sftpChannel;
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean canConnect() {
        if (this.session.isConnected() && this.sftpChannel.isConnected()) {
            return true;
        }
        JSch jsch = new JSch();
        try {
            Session session = jsch.getSession(this.remoteUser, this.remoteHost);
            session.setPassword(this.remotePassword);
            session.setConfig("StrictHostKeyChecking", "no");
            int timeout = 3000;
            session.connect(timeout);
            ChannelSftp sftpChannel = (ChannelSftp)session.openChannel("sftp");
            sftpChannel.connect(timeout);
            if (session.isConnected() && sftpChannel.isConnected()) {
                return true;
            }
        }
        catch (JSchException e) {
            this.logger.info("\u3010{}\u3011\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38", (Object)this.remoteHost);
        }
        return false;
    }

    public boolean isConnect() {
        return this.isConnect;
    }

    public void close() {
        if (this.sftpChannel != null) {
            this.sftpChannel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public void closeSchedule() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }
}

