/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class LocalIPAddressUtil {
    public static String getLocalIPAddress() {
        try {
            Enumeration<NetworkInterface> interfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (interfaceEnum.hasMoreElements()) {
                NetworkInterface networkInterface = interfaceEnum.nextElement();
                Enumeration<InetAddress> addressEnum = networkInterface.getInetAddresses();
                while (addressEnum.hasMoreElements()) {
                    InetAddress address = addressEnum.nextElement();
                    if (address.isLinkLocalAddress() || address.isLoopbackAddress() || address.getHostAddress().contains(":")) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isLocalIPAddress(String ipAddress) {
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            Enumeration<NetworkInterface> interfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (interfaceEnum.hasMoreElements()) {
                NetworkInterface networkInterface = interfaceEnum.nextElement();
                Enumeration<InetAddress> addressEnum = networkInterface.getInetAddresses();
                while (addressEnum.hasMoreElements()) {
                    InetAddress localAddress = addressEnum.nextElement();
                    if (!address.equals(localAddress)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        boolean localIPAddress = LocalIPAddressUtil.isLocalIPAddress("192.168.5.1");
        System.out.println("Local IP address: " + localIPAddress);
    }
}

