/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int AES_KEY_LENGTH = 16;
    private static final int AES_IV_LENGTH = 16;

    public static String encrypt(String plaintext, String keyString, String ivString) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(StandardCharsets.UTF_8), "AES");
        IvParameterSpec iv = new IvParameterSpec(ivString.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(1, (Key)key, iv);
        byte[] ciphertext = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(ciphertext);
    }

    public static String decrypt(String ciphertext, String keyString, String ivString) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(StandardCharsets.UTF_8), "AES");
        IvParameterSpec iv = new IvParameterSpec(ivString.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(2, (Key)key, iv);
        byte[] plaintext = cipher.doFinal(Base64.getDecoder().decode(ciphertext));
        return new String(plaintext, StandardCharsets.UTF_8);
    }

    public static SecretKey stringToSecretKey(String keyString) {
        return new SecretKeySpec(keyString.getBytes(StandardCharsets.UTF_8), "AES");
    }

    public static IvParameterSpec stringToIV(String ivString) {
        return new IvParameterSpec(ivString.getBytes(StandardCharsets.UTF_8));
    }

    public static String generateRandomKey() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] key = new byte[16];
        secureRandom.nextBytes(key);
        return Base64.getEncoder().encodeToString(key);
    }

    public static String generateRandomIV() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        return Base64.getEncoder().encodeToString(iv).substring(0, 16);
    }

    public static void main(String[] args) throws Exception {
        String plainText = "Hello, world!";
        String keyString = AESUtil.generateRandomKey();
        String ivString = AESUtil.generateRandomIV();
        System.out.println(keyString);
        System.out.println(ivString);
        String encryptedText = AESUtil.encrypt(plainText, keyString, ivString);
        String decryptedText = AESUtil.decrypt(encryptedText, keyString, ivString);
        System.out.println("Plain Text: " + plainText);
        System.out.println("Encrypted Text: " + encryptedText);
        System.out.println("Decrypted Text: " + decryptedText);
    }
}

