/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.service.impl;

import com.kdgcsoft.javafilesync.entity.AESKey;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.util.AESUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class MemoryFileAlterationObserverRepository
implements FileAlterationObserverRepository {
    private final Map<String, FileAlterationObserver> observerMap = new ConcurrentHashMap<String, FileAlterationObserver>();
    private AESKey aesKey;

    public MemoryFileAlterationObserverRepository() {
    }

    public MemoryFileAlterationObserverRepository(AESKey aesKey) {
        this.aesKey = aesKey;
    }

    @Override
    public String addObserver(FileAlterationObserver observer) {
        String key = this.getKey(observer);
        this.observerMap.put(key, observer);
        return key;
    }

    @Override
    public Map<String, FileAlterationObserver> getAllObserver() {
        return this.observerMap;
    }

    @Override
    public FileAlterationObserver getObserver(String observerId) {
        return this.observerMap.get(observerId);
    }

    @Override
    public void removeObserver(String observerId) {
        this.observerMap.remove(observerId);
    }

    private String getKey(FileAlterationObserver observer) {
        if (observer != null) {
            String absolutePath = observer.getDirectory().getAbsolutePath();
            return this.getKey(absolutePath);
        }
        return null;
    }

    private String getKey(String absolutePath) {
        if (this.aesKey != null) {
            try {
                return AESUtil.encrypt(absolutePath, this.aesKey.getKey(), this.aesKey.getIv());
            }
            catch (Exception e) {
                throw new RuntimeException("AES\u52a0\u5bc6\u5931\u8d25", e);
            }
        }
        return absolutePath;
    }
}

