/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.service.impl;

import com.kdgcsoft.javafilesync.entity.AESKey;
import com.kdgcsoft.javafilesync.listener.SftpAlterationListener;
import com.kdgcsoft.javafilesync.service.FileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.service.impl.MemoryFileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.util.AESUtil;
import com.kdgcsoft.javafilesync.util.MD5Util;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.monitor.FileAlterationListener;

public class MemoryFileAlterationListenerRepository
implements FileAlterationListenerRepository {
    private Map<String, FileAlterationListener> listenerMap = new ConcurrentHashMap<String, FileAlterationListener>();
    private String serverId;
    private AESKey aesKey;
    private FileAlterationObserverRepository observerRepository;

    public MemoryFileAlterationListenerRepository() {
        this.observerRepository = new MemoryFileAlterationObserverRepository();
    }

    public MemoryFileAlterationListenerRepository(String serverId, AESKey aesKey) {
        this.serverId = serverId;
        this.aesKey = aesKey;
        this.observerRepository = new MemoryFileAlterationObserverRepository(aesKey);
    }

    @Override
    public void addListener(String observerId, FileAlterationListener listener) {
        if (listener instanceof SftpAlterationListener) {
            SftpAlterationListener sftpAlterationListener = (SftpAlterationListener)listener;
            String remoteHost = sftpAlterationListener.getRemoteHost();
            String userName = sftpAlterationListener.getRemoteUser();
            String password = sftpAlterationListener.getRemotePassword();
            String destDir = sftpAlterationListener.getDestDir();
            try {
                userName = AESUtil.encrypt(userName, this.aesKey.getKey(), this.aesKey.getIv());
                password = AESUtil.encrypt(password, this.aesKey.getKey(), this.aesKey.getIv());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String generateStr = this.serverId + ":" + observerId + ":" + remoteHost + ":" + destDir + ":" + userName + ":" + password;
            String key = MD5Util.md5(generateStr);
            this.listenerMap.put(key, sftpAlterationListener);
        }
    }

    @Override
    public FileAlterationListener getListener(String listenerId) {
        return this.listenerMap.get(listenerId);
    }

    @Override
    public FileAlterationListener get(String observerId, String targetPath, String host, String user, String password) {
        String key = MD5Util.md5(this.serverId + ":" + observerId + ":" + targetPath + ":" + host + ":" + user + ":" + password);
        return this.getListener(key);
    }

    @Override
    public void removeListener(String listenerId) {
        this.listenerMap.remove(listenerId);
    }

    @Override
    public Map<String, FileAlterationListener> getAllListener(String observerId) {
        return this.listenerMap;
    }

    public void setAesKey(AESKey aesKey) {
        this.aesKey = aesKey;
    }
}

