/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.service.impl;

import com.kdgcsoft.javafilesync.entity.AESKey;
import com.kdgcsoft.javafilesync.entity.FileAlterationObserverEntity;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.util.AESUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public class JdbcFileAlterationObserverRepository
implements FileAlterationObserverRepository {
    private Map<String, FileAlterationObserver> observers = new ConcurrentHashMap<String, FileAlterationObserver>();
    public static final String INSERT_SQL = "INSERT INTO sync_file_alteration_observer (id, observer_id, server_id, status) VALUES(?, ?, ?, ?)";
    public static final String SELECT_SQL = "SELECT * FROM sync_file_alteration_observer WHERE observer_id = ? and server_id = ? and status = ?";
    public static final String SELECT_ALL_SQL = "SELECT * FROM sync_file_alteration_observer WHERE server_id = ? and status = ?";
    public static final String UPDATE_SQL = "UPDATE sync_file_alteration_observer SET status = ? WHERE observer_id = ? and server_id = ?";
    public static final String DELETE_SQL = "DELETE FROM sync_file_alteration_observer WHERE observer_id = ? and server_id = ?";
    public static final String DELETE_LISTENER_SQL = "SELECT * FROM sync_alteration_listener WHERE observer_id = ? ";
    private final JdbcTemplate jdbcTemplate;
    private final AESKey aesKey;
    private final String serverId;

    public JdbcFileAlterationObserverRepository(DataSource dataSource, String serverId, AESKey aesKey) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.serverId = serverId;
        this.aesKey = aesKey;
    }

    @Override
    public String addObserver(FileAlterationObserver observer) {
        String id;
        File directory = observer.getDirectory();
        String absolutePath = directory.getAbsolutePath();
        try {
            id = AESUtil.encrypt(absolutePath, this.aesKey.getKey(), this.aesKey.getIv());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.observers.put(id, observer);
        this.add(observer);
        return id;
    }

    @Override
    public Map<String, FileAlterationObserver> getAllObserver() {
        HashMap<String, FileAlterationObserver> collect = new HashMap<String, FileAlterationObserver>();
        if (!this.observers.isEmpty()) {
            return this.observers;
        }
        try {
            List<FileAlterationObserverEntity> entityList = this.selectAll();
            for (FileAlterationObserverEntity observerEntity : entityList) {
                String observerId = observerEntity.getObserverId();
                String decrypt = AESUtil.decrypt(observerId, this.aesKey.getKey(), this.aesKey.getIv());
                FileAlterationObserver observer = new FileAlterationObserver(decrypt);
                collect.put(observerId, observer);
                this.observers.put(observerId, observer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return collect;
    }

    @Override
    public FileAlterationObserver getObserver(String observerId) {
        FileAlterationObserver observer = this.observers.get(observerId);
        if (observer == null) {
            FileAlterationObserverEntity select = this.select(observerId);
            if (select == null) {
                return null;
            }
            try {
                String decrypt = AESUtil.decrypt(observerId, this.aesKey.getKey(), this.aesKey.getIv());
                observer = new FileAlterationObserver(decrypt);
                this.observers.put(observerId, observer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return observer;
    }

    @Override
    public void removeObserver(String observerId) {
        this.observers.remove(observerId);
        this.removeJdbcObserver(observerId);
    }

    private void removeJdbcObserver(String observerId) {
        try {
            this.jdbcTemplate.update(DELETE_SQL, new Object[]{observerId, this.serverId});
            this.jdbcTemplate.update(DELETE_LISTENER_SQL, new Object[]{observerId});
        }
        catch (DataAccessException e) {
            throw new RuntimeException("\u5220\u9664\u76d1\u63a7\u76ee\u5f55\u3010" + observerId + "\u3011\u5931\u8d25", e);
        }
    }

    private List<FileAlterationObserverEntity> selectAll() {
        return this.jdbcTemplate.query(SELECT_ALL_SQL, new Object[]{this.serverId, "0"}, (rs, rowNum) -> new FileAlterationObserverEntity(rs.getString("id"), rs.getString("observer_id"), rs.getString("server_id"), rs.getString("status")));
    }

    private FileAlterationObserverEntity select(String observerId) {
        List query = this.jdbcTemplate.query(SELECT_SQL, new Object[]{observerId, this.serverId, "0"}, (rs, rowNum) -> new FileAlterationObserverEntity(rs.getString("id"), rs.getString("observer_id"), rs.getString("server_id"), rs.getString("status")));
        if (CollectionUtils.isEmpty((Collection)query)) {
            throw new RuntimeException("\u76d1\u63a7\u76ee\u5f55ID\u3010" + observerId + "\u3011\u4e0d\u5b58\u5728");
        }
        return (FileAlterationObserverEntity)query.get(0);
    }

    private void add(FileAlterationObserver observer) {
        String id = UUID.randomUUID().toString().replace("-", "");
        File directory = observer.getDirectory();
        String absolutePath = directory.getAbsolutePath();
        try {
            String observerId = AESUtil.encrypt(absolutePath, this.aesKey.getKey(), this.aesKey.getIv());
            String status = "0";
            this.jdbcTemplate.update(INSERT_SQL, new Object[]{id, observerId, this.serverId, status});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

