/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.service.impl;

import com.jcraft.jsch.JSchException;
import com.kdgcsoft.javafilesync.entity.AESKey;
import com.kdgcsoft.javafilesync.entity.FileAlterationListenerEntity;
import com.kdgcsoft.javafilesync.exception.ListenerExistException;
import com.kdgcsoft.javafilesync.listener.SftpAlterationListener;
import com.kdgcsoft.javafilesync.service.FileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.service.impl.MemoryFileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.util.AESUtil;
import com.kdgcsoft.javafilesync.util.MD5Util;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public class JdbcFileAlterationListenerRepository
implements FileAlterationListenerRepository {
    public static final String INSERT_SQL = "INSERT INTO sync_alteration_listener (id, server_id, dest_dir, remote_host, user_name, password, observer_id) VALUES(?, ?, ?, ?, ?, ?, ?)";
    public static final String SELECT_SQL = "SELECT * FROM sync_alteration_listener WHERE id = ? ";
    public static final String SELECT_ALL_SQL = "SELECT * FROM sync_alteration_listener WHERE observer_id = ? and server_id = ?";
    public static final String DELETE_SQL = "DELETE FROM sync_alteration_listener WHERE id = ?";
    private final Map<String, FileAlterationListener> listenerMap = new ConcurrentHashMap<String, FileAlterationListener>();
    private FileAlterationObserverRepository observerRepository = new MemoryFileAlterationObserverRepository();
    private final JdbcTemplate jdbcTemplate;
    private final AESKey aesKey;
    private final String serverId;

    public JdbcFileAlterationListenerRepository(DataSource dataSource, String serverId, AESKey aesKey) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.serverId = serverId;
        this.aesKey = aesKey;
    }

    @Override
    public void addListener(String observerId, FileAlterationListener listener) {
        if (listener instanceof SftpAlterationListener) {
            SftpAlterationListener sftpAlterationListener = (SftpAlterationListener)listener;
            String remoteHost = sftpAlterationListener.getRemoteHost();
            String userName = sftpAlterationListener.getRemoteUser();
            String password = sftpAlterationListener.getRemotePassword();
            String destDir = sftpAlterationListener.getDestDir();
            try {
                userName = AESUtil.encrypt(userName, this.aesKey.getKey(), this.aesKey.getIv());
                password = AESUtil.encrypt(password, this.aesKey.getKey(), this.aesKey.getIv());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String generateStr = this.serverId + ":" + observerId + ":" + remoteHost + ":" + destDir + ":" + userName + ":" + password;
            String key = MD5Util.md5(generateStr);
            FileAlterationListener fileAlterationListener = this.getListener(key);
            if (fileAlterationListener != null) {
                throw new ListenerExistException("\u76d1\u542c\u5668\u3010 " + key + "\u3011\u5df2\u7ecf\u5b58\u5728");
            }
            this.listenerMap.put(key, sftpAlterationListener);
            this.put(observerId, remoteHost, destDir, userName, password);
        }
    }

    @Override
    public FileAlterationListener getListener(String listenerId) {
        FileAlterationListener fileAlterationListener = this.listenerMap.get(listenerId);
        if (fileAlterationListener != null) {
            return fileAlterationListener;
        }
        return this.selectListener(listenerId);
    }

    @Override
    public FileAlterationListener get(String observerId, String targetPath, String host, String user, String password) {
        String key = MD5Util.md5(this.serverId + ":" + observerId + ":" + targetPath + ":" + host + ":" + user + ":" + password);
        return this.getListener(key);
    }

    public void put(String observerId, String remoteHost, String destDir, String userName, String password) {
        try {
            String key = MD5Util.md5(this.serverId + ":" + observerId + ":" + destDir + ":" + remoteHost + ":" + userName + ":" + password);
            this.jdbcTemplate.update(INSERT_SQL, new Object[]{key, this.serverId, destDir, remoteHost, userName, password, observerId});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void selectAll(String observerId) {
        FileAlterationObserver observer = this.observerRepository.getObserver(observerId);
        File directory = observer.getDirectory();
        String sourcePath = directory.getAbsolutePath();
        List query = this.jdbcTemplate.query(SELECT_ALL_SQL, new Object[]{observerId, this.serverId}, (rs, rowNum) -> new FileAlterationListenerEntity(rs.getString("id"), rs.getString("server_id"), rs.getString("dest_dir"), rs.getString("remote_host"), rs.getString("user_name"), rs.getString("password"), rs.getString("observer_id")));
        for (FileAlterationListenerEntity entity : query) {
            SftpAlterationListener listener;
            String password;
            String username;
            try {
                username = AESUtil.decrypt(entity.getUserName(), this.aesKey.getKey(), this.aesKey.getIv());
                password = AESUtil.decrypt(entity.getPassword(), this.aesKey.getKey(), this.aesKey.getIv());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                listener = new SftpAlterationListener(sourcePath, entity.getDestDir(), entity.getRemoteHost(), username, password);
            }
            catch (JSchException e) {
                throw new RuntimeException(e);
            }
            this.listenerMap.put(entity.getId(), listener);
        }
    }

    private void delete(String id) {
        this.jdbcTemplate.update(DELETE_SQL, new Object[]{id});
    }

    @Override
    public void removeListener(String listenerId) {
        this.listenerMap.remove(listenerId);
        this.delete(listenerId);
    }

    @Override
    public Map<String, FileAlterationListener> getAllListener(String observerId) {
        if (!this.listenerMap.isEmpty()) {
            return this.listenerMap;
        }
        this.selectAll(observerId);
        return this.listenerMap;
    }

    public FileAlterationListener selectListener(String listenerId) {
        List query = this.jdbcTemplate.query(SELECT_SQL, new Object[]{listenerId}, (rs, rowNum) -> new FileAlterationListenerEntity(rs.getString("id"), rs.getString("server_id"), rs.getString("dest_dir"), rs.getString("remote_host"), rs.getString("user_name"), rs.getString("password"), rs.getString("observer_id")));
        if (!CollectionUtils.isEmpty((Collection)query)) {
            try {
                FileAlterationListenerEntity entity = (FileAlterationListenerEntity)query.get(0);
                String userName = entity.getUserName();
                userName = AESUtil.decrypt(userName, this.aesKey.getKey(), this.aesKey.getIv());
                String password = entity.getPassword();
                password = AESUtil.decrypt(password, this.aesKey.getKey(), this.aesKey.getIv());
                FileAlterationObserver observer = this.observerRepository.getObserver(entity.getObserverId());
                String sourceDir = observer.getDirectory().getAbsolutePath();
                SftpAlterationListener listener = new SftpAlterationListener(sourceDir, entity.getDestDir(), entity.getRemoteHost(), userName, password);
                this.listenerMap.put(listenerId, listener);
                return listener;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public FileAlterationObserverRepository getObserverRepository() {
        return this.observerRepository;
    }

    public void setObserverRepository(FileAlterationObserverRepository observerRepository) {
        this.observerRepository = observerRepository;
    }
}

