/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.service.impl;

import com.jcraft.jsch.JSchException;
import com.kdgcsoft.javafilesync.bean.AlterationListenerStatus;
import com.kdgcsoft.javafilesync.exception.ListenerExistException;
import com.kdgcsoft.javafilesync.listener.LocalFileAlterationListener;
import com.kdgcsoft.javafilesync.listener.SftpAlterationListener;
import com.kdgcsoft.javafilesync.service.FileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.FileAlterationMonitorService;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.service.impl.MemoryFileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.impl.MemoryFileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.util.LocalIPAddressUtil;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAlterationMonitorServiceImpl
implements FileAlterationMonitorService {
    private final Logger logger = LoggerFactory.getLogger(FileAlterationMonitorServiceImpl.class);
    private final FileAlterationMonitor monitor;
    private FileAlterationObserverRepository observerRepository = new MemoryFileAlterationObserverRepository();
    private FileAlterationListenerRepository listenerRepository = new MemoryFileAlterationListenerRepository();

    public FileAlterationMonitorServiceImpl() {
        this.monitor = new FileAlterationMonitor();
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createFileAlterationObserver(String filePath) {
        Map<String, FileAlterationObserver> allObserver = this.observerRepository.getAllObserver();
        for (Map.Entry<String, FileAlterationObserver> observerEntry : allObserver.entrySet()) {
            FileAlterationObserver value = observerEntry.getValue();
            if (!value.getDirectory().getAbsolutePath().equals(filePath)) continue;
            this.logger.info("\u76d1\u63a7\u670d\u52a1\u3010{}\u3011\u521b\u5efa\u6210\u529f", (Object)filePath);
            this.monitor.addObserver(value);
            return observerEntry.getKey();
        }
        FileAlterationObserver observer = new FileAlterationObserver(filePath);
        this.monitor.addObserver(observer);
        String s = this.observerRepository.addObserver(observer);
        this.logger.info("\u76d1\u63a7\u670d\u52a1\u3010{}\u3011\u521b\u5efa\u6210\u529f", (Object)filePath);
        return s;
    }

    @Override
    public boolean removeFileAlterationObserver(String observerId) {
        try {
            FileAlterationObserver observer = this.observerRepository.getObserver(observerId);
            if (observer == null) {
                this.logger.warn("\u76d1\u63a7\u670d\u52a1\u3010{}\u3011\u4e0d\u5b58\u5728", (Object)observerId);
                return false;
            }
            this.monitor.removeObserver(observer);
            this.observerRepository.removeObserver(observerId);
        }
        catch (Exception e) {
            this.logger.info("\u76d1\u63a7\u670d\u52a1\u3010{}\u3011\u79fb\u9664\u5931\u8d25", (Object)observerId);
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public AlterationListenerStatus addAlterationListener(String observerId, String targetPath, String host, String user, String password) {
        FileAlterationObserver observer = this.observerRepository.getObserver(observerId);
        if (observer == null) {
            this.logger.error("\u76d1\u63a7\u670d\u52a1\u3010 {} \u3011\u4e0d\u5b58\u5728", (Object)observerId);
            return AlterationListenerStatus.OBSERVER_NOT_EXIST;
        }
        String sourcePath = observer.getDirectory().getAbsolutePath();
        FileAlterationListener fileAlterationListener = this.listenerRepository.get(observerId, targetPath, host, user, password);
        if (fileAlterationListener == null) {
            if (LocalIPAddressUtil.isLocalIPAddress(host)) {
                fileAlterationListener = new LocalFileAlterationListener(sourcePath, targetPath);
            } else {
                try {
                    fileAlterationListener = new SftpAlterationListener(sourcePath, targetPath, host, user, password);
                }
                catch (JSchException e) {
                    return this.getAlterationListenerStatusFromException((Exception)((Object)e));
                }
            }
            try {
                this.listenerRepository.addListener(observerId, fileAlterationListener);
            }
            catch (Exception e) {
                return this.getAlterationListenerStatusFromException(e);
            }
            observer.addListener(fileAlterationListener);
        }
        this.logger.info("\u76d1\u63a7\u670d\u52a1\u3010{}\u3011\u76d1\u542c\u6210\u529f", (Object)targetPath);
        return AlterationListenerStatus.SUCCESS;
    }

    @Override
    public boolean removeAlterationListener(String observerId, String listenerId) {
        FileAlterationObserver observer = this.observerRepository.getObserver(observerId);
        if (observer == null) {
            this.logger.warn("\u8fdc\u7a0b\u76d1\u63a7\u76ee\u5f55\u3010{}\u3011\u4e0d\u5b58\u5728", (Object)observerId);
        } else {
            FileAlterationListener fileAlterationListener = this.listenerRepository.getListener(listenerId);
            if (fileAlterationListener == null) {
                this.logger.warn("\u6587\u4ef6\u76d1\u542c\u670d\u52a1\u3010{}\u3011\u4e0d\u5b58\u5728", (Object)listenerId);
            } else {
                if (fileAlterationListener instanceof SftpAlterationListener) {
                    SftpAlterationListener listener = (SftpAlterationListener)fileAlterationListener;
                    listener.destroy();
                }
                observer.removeListener(fileAlterationListener);
                this.listenerRepository.removeListener(listenerId);
                this.logger.info("\u8fdc\u7a0b\u76d1\u63a7\u76ee\u5f55\u3010{}\u3011\u79fb\u9664\u6210\u529f", (Object)listenerId);
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private AlterationListenerStatus getAlterationListenerStatusFromException(Exception e) {
        if (e instanceof JSchException) {
            JSchException jse = (JSchException)((Object)e);
            if (jse.getMessage().contains("Auth fail")) {
                return AlterationListenerStatus.AUTHENTICATION_FAILED;
            }
            if (jse.getCause() instanceof ConnectException || jse.getCause() instanceof UnknownHostException) {
                return AlterationListenerStatus.HOST_UNREACHABLE;
            }
            if (jse.getMessage().equals("java.net.SocketTimeoutException")) {
                return AlterationListenerStatus.CONNECTION_TIMEOUT;
            }
            if (jse.getMessage().contains("Auth fail") || jse.getMessage().contains("UnknownHostKey") || jse.getMessage().contains("algorithm negotiation fail") || jse.getMessage().contains("no matching cipher found")) {
                return AlterationListenerStatus.SSH_CONFIG_ERROR;
            }
        } else if (e instanceof ListenerExistException) {
            this.logger.warn(e.getLocalizedMessage());
            return AlterationListenerStatus.LISTENER_EXIST;
        }
        e.printStackTrace();
        return AlterationListenerStatus.UNKNOWN_ERROR;
    }

    public void setFileAlterationObserverRepository(FileAlterationObserverRepository repository) {
        this.observerRepository = repository;
    }

    public FileAlterationListenerRepository getListenerRepository() {
        return this.listenerRepository;
    }

    public void setListenerRepository(FileAlterationListenerRepository listenerRepository) {
        this.listenerRepository = listenerRepository;
    }

    public FileAlterationMonitor getMonitor() {
        return this.monitor;
    }
}

