/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.listener;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.kdgcsoft.javafilesync.bean.FileOpStatus;
import com.kdgcsoft.javafilesync.bean.UploadStatus;
import com.kdgcsoft.javafilesync.util.SftpFileOperator;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpAlterationListener
implements FileAlterationListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String sourceDir;
    private final String destDir;
    private final SftpFileOperator fileOperator;
    private String remoteHost;
    private String remoteUser;
    private String remotePassword;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentLinkedQueue<FileType> linkedQueue = new ConcurrentLinkedQueue();

    public SftpAlterationListener(String sourceDir, String destDir, String remoteHost, String remoteUser, String remotePassword) throws JSchException {
        this.sourceDir = sourceDir;
        this.destDir = destDir;
        this.remoteHost = remoteHost;
        this.remoteUser = remoteUser;
        this.remotePassword = remotePassword;
        this.fileOperator = new SftpFileOperator(remoteHost, remoteUser, remotePassword);
        this.doScheduleAtFixedRate();
    }

    public void onStart(FileAlterationObserver observer) {
        this.logger.debug("\u3010{}\u3011\u3010{}\u3011\u6587\u4ef6\u63a5\u6536\u670d\u52a1\u5df2\u542f\u52a8\uff1a ", (Object)this.remoteHost, (Object)this.destDir);
    }

    public void onDirectoryCreate(File directory) {
        if (this.fileOperator.isConnect()) {
            this.doDirectoryCreate(directory);
        } else {
            this.linkedQueue.offer(new FileType(1, directory));
        }
    }

    public void onDirectoryChange(File directory) {
        this.logger.info("\u4fee\u6539\u76ee\u5f55 " + directory.getAbsolutePath());
    }

    public void onDirectoryDelete(File directory) {
        if (this.fileOperator.isConnect()) {
            this.doDirectoryDelete(directory);
        } else {
            this.linkedQueue.offer(new FileType(2, directory));
        }
    }

    public void onFileCreate(File file) {
        if (this.fileOperator.isConnect()) {
            this.doFileCreate(file);
        } else {
            this.linkedQueue.offer(new FileType(3, file));
        }
    }

    public void onFileChange(File file) {
        this.onFileCreate(file);
    }

    public void onFileDelete(File file) {
        if (this.fileOperator.isConnect()) {
            this.doFileDelete(file);
        } else {
            this.linkedQueue.offer(new FileType(4, file));
        }
    }

    public void onStop(FileAlterationObserver observer) {
        this.logger.debug("\u3010{}\u3011\u3010{}\u3011\u6587\u4ef6\u63a5\u6536\u670d\u52a1\u5df2\u5173\u95ed\uff1a ", (Object)this.remoteHost, (Object)this.destDir);
        this.fileOperator.close();
    }

    public void destroy() {
        this.fileOperator.close();
        this.fileOperator.closeSchedule();
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    private String getRemoteRelatePath(File file) {
        Path oldRootPath = Paths.get(this.sourceDir, new String[0]);
        Path newRootPath = Paths.get(this.destDir, new String[0]);
        Path relativePath = oldRootPath.relativize(Paths.get(file.getAbsolutePath(), new String[0]));
        return newRootPath.resolve(relativePath).toString().replace("\\", "/");
    }

    private void doDirectoryCreate(File directory) {
        String path = this.getRemoteRelatePath(directory);
        try {
            FileOpStatus mkdir = this.fileOperator.mkdir(path);
            if (FileOpStatus.SUCCESS == mkdir) {
                this.logger.debug("\u3010{}\u3011 \u3010{}\u3011 \u76ee\u5f55\u521b\u5efa\u6210\u529f", (Object)this.remoteHost, (Object)path);
            }
        }
        catch (SftpException e) {
            throw new RuntimeException(e);
        }
    }

    private void doDirectoryDelete(File directory) {
        String remoteRelatePath = this.getRemoteRelatePath(directory);
        try {
            this.fileOperator.deleteDir(remoteRelatePath);
            this.logger.info("\u8fdc\u7a0b\u76ee\u5f55\u3010{}\u3011\u3010{}\u3011\u5220\u9664\u6210\u529f\u3002", (Object)this.remoteHost, (Object)remoteRelatePath);
        }
        catch (JSchException | SftpException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void doFileCreate(File file) {
        try {
            String localFilePath = file.getAbsolutePath();
            String destPath = this.getRemoteRelatePath(file);
            UploadStatus copy = this.fileOperator.copy(localFilePath, destPath);
            this.printLog(copy, destPath);
        }
        catch (SftpException e) {
            throw new RuntimeException(e);
        }
    }

    private void doFileDelete(File file) {
        String remoteFilePath = this.getRemoteRelatePath(file);
        try {
            this.logger.debug("\u5f00\u59cb\u5220\u9664\u8fdc\u7a0b\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011", (Object)this.remoteHost, (Object)remoteFilePath);
            this.fileOperator.delete(this.getRemoteRelatePath(file));
            this.logger.info("\u8fdc\u7a0b\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u5220\u9664\u6210\u529f\u3002", (Object)this.remoteHost, (Object)remoteFilePath);
        }
        catch (JSchException | SftpException e) {
            throw new RuntimeException(e);
        }
    }

    private void doScheduleAtFixedRate() {
        this.executor.scheduleAtFixedRate(() -> {
            FileType poll;
            if (this.fileOperator.isConnect() && (poll = this.linkedQueue.poll()) != null) {
                switch (poll.getType()) {
                    case 1: {
                        this.doDirectoryCreate(poll.getFile());
                        break;
                    }
                    case 2: {
                        this.doDirectoryDelete(poll.getFile());
                        break;
                    }
                    case 3: {
                        this.doFileCreate(poll.getFile());
                        break;
                    }
                    case 4: {
                        this.onFileDelete(poll.getFile());
                    }
                }
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    private void printLog(UploadStatus status, String destPath) {
        switch (status) {
            case FILE_EXIST: {
                this.logger.debug("\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u5df2\u7ecf\u5b58\u5728,\u65e0\u9700\u4e0a\u4f20\u3002", (Object)this.remoteHost, (Object)destPath);
                break;
            }
            case UPLOAD_SUCCESS: {
                this.logger.info("\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u4e0a\u4f20\u6210\u529f\u3002", (Object)this.remoteHost, (Object)destPath);
                break;
            }
            case UPLOAD_FAILED: {
                this.logger.error("\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u4e0a\u4f20\u5931\u8d25\u3002", (Object)this.remoteHost, (Object)destPath);
                break;
            }
            case NOT_PERMISSION: {
                this.logger.error("\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u6743\u9650\u4e0d\u8db3\u3002", (Object)this.remoteHost, (Object)destPath);
                break;
            }
            case NETWORK_ERROR: {
                this.logger.error("\u6587\u4ef6\u3010{}\u3011\u3010{}\u3011\u4e0a\u4f20\u53d1\u751f\u7f51\u7edc\u9519\u8bef\u3002", (Object)this.remoteHost, (Object)destPath);
            }
        }
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    private static class FileType {
        private Integer type;
        private File file;

        public FileType(Integer type, File file) {
            this.type = type;
            this.file = file;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }
}

