/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.javafilesync.config;

import com.kdgcsoft.javafilesync.bean.FileSyncProperties;
import com.kdgcsoft.javafilesync.service.FileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.FileAlterationObserverRepository;
import com.kdgcsoft.javafilesync.service.impl.MemoryFileAlterationListenerRepository;
import com.kdgcsoft.javafilesync.service.impl.MemoryFileAlterationObserverRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FileSyncProperties.class})
@ConditionalOnProperty(prefix="file.sync", name={"store-type"}, havingValue="mem")
public class MemoryFileSyncRepositoryConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @ConditionalOnMissingBean
    FileAlterationObserverRepository observerRepository(FileSyncProperties fileSyncProperties) {
        this.logger.info("\u57fa\u4e8e\u5185\u5b58\u7684FileAlterationObserverRepository \u5b58\u50a8");
        return new MemoryFileAlterationObserverRepository(fileSyncProperties.getAesKey());
    }

    @Bean
    @ConditionalOnMissingBean
    FileAlterationListenerRepository fileAlterationListenerRepository(FileSyncProperties fileSyncProperties) {
        this.logger.info("\u57fa\u4e8e\u5185\u5b58\u7684FileAlterationListenerRepository\u5b58\u50a8");
        return new MemoryFileAlterationListenerRepository(fileSyncProperties.getServerId(), fileSyncProperties.getAesKey());
    }
}

